/*
 * Decompiled with CFR 0.152.
 */
package pl.michal.grzesiak.criticizer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import pl.michal.grzesiak.criticizer.ClassesProvider;
import pl.michal.grzesiak.criticizer.IncorrectValidation;
import pl.michal.grzesiak.criticizer.ReferenceValidator;
import pl.michal.grzesiak.criticizer.ValidationAnnotationChecker;

public class Criticizer {
    private final ClassesProvider classesProvider;
    private final ValidationAnnotationChecker validationAnnotationChecker;
    private final ReferenceValidator referenceValidator;

    Criticizer(ClassesProvider classesProvider, ValidationAnnotationChecker validationAnnotationChecker, ReferenceValidator referenceValidator) {
        this.classesProvider = classesProvider;
        this.validationAnnotationChecker = validationAnnotationChecker;
        this.referenceValidator = referenceValidator;
    }

    public List<IncorrectValidation> checkAllValidationsIn(String packageName) {
        return this.checkAllValidationsIn(packageName, "");
    }

    public List<IncorrectValidation> checkAllValidationsIn(String packageName, String classNameSuffix) {
        List<Class<?>> classes = this.classesProvider.getClasses(packageName, classNameSuffix);
        return this.findIncorrectValidationsIn(classes);
    }

    private List<IncorrectValidation> findIncorrectValidationsIn(List<Class<?>> classes) {
        ArrayList<IncorrectValidation> incorrectValidations = new ArrayList<IncorrectValidation>();
        for (Class<?> parentClazz : classes) {
            Field[] parentClassFields = parentClazz.getDeclaredFields();
            List<String> classesWithLackOfValidation = this.findClassesWithLackOfValidation(parentClassFields);
            if (classesWithLackOfValidation.isEmpty()) continue;
            IncorrectValidation incorrectValidation = new IncorrectValidation(parentClazz.getCanonicalName(), classesWithLackOfValidation);
            incorrectValidations.add(incorrectValidation);
        }
        return incorrectValidations;
    }

    private List<String> findClassesWithLackOfValidation(Field[] parentClassFields) {
        ArrayList<String> classesWithLackOfValidation = new ArrayList<String>();
        for (Field parentClassField : parentClassFields) {
            boolean isAnnotatedProperly;
            boolean hasChildAnyValidationAnnotation = this.validationAnnotationChecker.hasAnyChildValidationAnnotation(parentClassField);
            if (!hasChildAnyValidationAnnotation || (isAnnotatedProperly = this.referenceValidator.isAnnotationPutOnReference(parentClassField))) continue;
            classesWithLackOfValidation.add(parentClassField.getName());
        }
        return classesWithLackOfValidation;
    }
}

