package pl.michal.grzesiak.criticizer;

public class CriticizerFactory {

    private CriticizerFactory() {
    }

    public static Criticizer create() {
        ClassesProvider classesProvider = new ClassesProvider();
        ChildFieldsExtractor childFieldsExtractor = new ChildFieldsExtractor();
        ValidationAnnotationChecker validationAnnotationChecker = new ValidationAnnotationChecker(childFieldsExtractor);
        ReferenceValidator referenceValidator = new ReferenceValidator();

        return new Criticizer(classesProvider, validationAnnotationChecker, referenceValidator);
    }
}
