/*
 * Decompiled with CFR 0.152.
 */
package pl.michal.grzesiak.criticizer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import pl.michal.grzesiak.criticizer.ClassFindingException;

class ClassesProvider {
    private static final String JAVA_CLASS_EXTENSION = ".class";

    ClassesProvider() {
    }

    List<Class<?>> getClasses(String packageName, String classNameSuffix) {
        List<File> directories = this.getDirectoriesForPackage(packageName);
        return directories.stream().map(directory -> this.getClassesInDirectory((File)directory, packageName, classNameSuffix)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<File> getDirectoriesForPackage(String packageName) {
        Enumeration<URL> resources;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException e) {
            resources = Collections.emptyEnumeration();
        }
        ArrayList<File> directories = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            directories.add(new File(resource.getFile()));
        }
        return directories;
    }

    private List<Class<?>> getClassesInDirectory(File directory, String packageName, String classNameSuffix) {
        Path directoryPath = directory.toPath();
        try {
            return Files.walk(directoryPath, new FileVisitOption[0]).filter(currentPath -> this.isJavaClassWithSuffix(classNameSuffix, (Path)currentPath)).map(currentPath -> this.buildClassCanonicalName(packageName, directoryPath, (Path)currentPath)).map(this::convertToClass).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new ClassFindingException("Unable to read files from the directory: " + directoryPath.toString(), e);
        }
    }

    private boolean isJavaClassWithSuffix(String classNameSuffix, Path currentPath) {
        return currentPath.toString().endsWith(classNameSuffix + JAVA_CLASS_EXTENSION);
    }

    private String buildClassCanonicalName(String packageName, Path directoryPath, Path currentPath) {
        String path = packageName + "." + directoryPath.relativize(currentPath).toString().replace('/', '.');
        return path.substring(0, path.length() - JAVA_CLASS_EXTENSION.length());
    }

    private Class<?> convertToClass(String path) {
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException e) {
            throw new ClassFindingException("Unable to find class file with name: " + path, e);
        }
    }
}

