package pl.michal.grzesiak.criticizer;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

import static java.util.Arrays.asList;

class ChildFieldsExtractor {

    List<Field> getFieldsFrom(Field field) {
        Field[] declaredFields = resolveClass(field).getDeclaredFields();
        return asList(declaredFields);
    }

    private Class<?> resolveClass(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            return resolveParametrizedTypes(genericType);
        } else {
            return field.getType();
        }
    }

    private Class<?> resolveParametrizedTypes(Type genericType) {
        //handling recurention collections //TODO: simplified it
        if (genericType instanceof ParameterizedType) {
            Type actualTypeArgument = ((ParameterizedType) genericType).getActualTypeArguments()[0];
            if (actualTypeArgument instanceof TypeVariable) {
                return genericType.getClass();
            } else {
                return resolveParametrizedTypes(actualTypeArgument);
            }
        }
        return (Class<?>) genericType;
    }
}
