/*
 * Decompiled with CFR 0.152.
 */
package pl.michal.grzesiak.criticizer;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;

class ChildFieldsExtractor {
    ChildFieldsExtractor() {
    }

    List<Field> getFieldsFrom(Field field) {
        Field[] declaredFields = this.resolveClass(field).getDeclaredFields();
        return Arrays.asList(declaredFields);
    }

    private Class<?> resolveClass(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            return this.resolveParametrizedTypes(genericType);
        }
        return field.getType();
    }

    private Class<?> resolveParametrizedTypes(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            Type actualTypeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (actualTypeArgument instanceof TypeVariable) {
                return genericType.getClass();
            }
            return this.resolveParametrizedTypes(actualTypeArgument);
        }
        return (Class)genericType;
    }
}

