/*
 * Decompiled with CFR 0.152.
 */
package pl.michal.grzesiak.criticizer;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import pl.michal.grzesiak.criticizer.ClassesProvider;
import pl.michal.grzesiak.criticizer.IncorrectValidation;
import pl.michal.grzesiak.criticizer.ReferenceValidator;
import pl.michal.grzesiak.criticizer.ValidationAnnotationChecker;

public class Criticizer {
    private final ClassesProvider classesProvider;
    private final ValidationAnnotationChecker validationAnnotationChecker;
    private final ReferenceValidator referenceValidator;

    Criticizer(ClassesProvider classesProvider, ValidationAnnotationChecker validationAnnotationChecker, ReferenceValidator referenceValidator) {
        this.classesProvider = classesProvider;
        this.validationAnnotationChecker = validationAnnotationChecker;
        this.referenceValidator = referenceValidator;
    }

    public List<IncorrectValidation> checkAllValidationsIn(String packageName) {
        return this.checkAllValidationsIn(packageName, "");
    }

    public List<IncorrectValidation> checkAllValidationsIn(String packageName, String classNameSuffix) {
        List<Class<?>> classes = this.classesProvider.getClasses(packageName, classNameSuffix);
        return this.findIncorrectValidationsIn(classes);
    }

    private List<IncorrectValidation> findIncorrectValidationsIn(List<Class<?>> classes) {
        ArrayList<IncorrectValidation> incorrectValidations = new ArrayList<IncorrectValidation>();
        for (Class<?> parentClazz : classes) {
            Field[] parentClassFields = parentClazz.getDeclaredFields();
            List<String> fieldsWithLackOfValidation = this.findFieldsWithLackOfValidation(parentClassFields);
            if (fieldsWithLackOfValidation.isEmpty()) continue;
            IncorrectValidation incorrectValidation = new IncorrectValidation(parentClazz.getCanonicalName(), fieldsWithLackOfValidation);
            incorrectValidations.add(incorrectValidation);
        }
        return incorrectValidations;
    }

    private List<String> findFieldsWithLackOfValidation(Field[] parentClassFields) {
        ArrayList<String> classesWithLackOfValidation = new ArrayList<String>();
        for (Field parentClassField : parentClassFields) {
            this.findGenericFieldWithDeadValidation(parentClassField).ifPresent(classesWithLackOfValidation::add);
            this.findFieldWithDeadValidation(parentClassField).ifPresent(classesWithLackOfValidation::add);
        }
        return classesWithLackOfValidation;
    }

    private Optional<String> findFieldWithDeadValidation(Field parentClassField) {
        boolean isAnnotatedProperly;
        boolean hasChildAnyValidationAnnotation = this.validationAnnotationChecker.hasAnyChildValidationAnnotation(parentClassField);
        if (hasChildAnyValidationAnnotation && !(isAnnotatedProperly = this.referenceValidator.isAnnotationPutOnReference(parentClassField))) {
            return Optional.of(parentClassField.getName());
        }
        return Optional.empty();
    }

    private Optional<String> findGenericFieldWithDeadValidation(Field parentClassField) {
        boolean isAnnotatedProperly;
        boolean genericField = this.isFieldGeneric(parentClassField.getGenericType());
        if (genericField && !(isAnnotatedProperly = this.referenceValidator.isAnnotationPutOnReference(parentClassField))) {
            return Optional.of(parentClassField.getName());
        }
        return Optional.empty();
    }

    private boolean isFieldGeneric(Type genericType) {
        if (ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            Type actualTypeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (TypeVariable.class.isAssignableFrom(actualTypeArgument.getClass())) {
                return true;
            }
            this.isFieldGeneric(actualTypeArgument);
        }
        return false;
    }
}

