package pl.michal.grzesiak.criticizer;

import javax.validation.Valid;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

import static java.util.Arrays.stream;

class ReferenceValidator {

    boolean isAnnotationPutOnReference(Field field) {
        Annotation[] annotations = field.getAnnotations();

        return stream(annotations)
                .anyMatch(annotation -> Valid.class.isAssignableFrom(annotation.annotationType()));
    }
}
