/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.kafka;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.netroute.hussar.service.kafka.api.KafkaTopic;

class KafkaTopicConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaTopicConfigurer.class);
    private static final short REPLICATION_FACTOR = 1;
    private static final Duration KAFKA_TIMEOUT = Duration.ofSeconds(5L);

    void configure(@NonNull AdminClient adminClient, @NonNull KafkaTopic topic) {
        if (adminClient == null) {
            throw new NullPointerException("adminClient is marked non-null but is null");
        }
        if (topic == null) {
            throw new NullPointerException("topic is marked non-null but is null");
        }
        log.info("Creating {}", (Object)topic);
        NewTopic newTopic = this.mapToNewTopic(topic);
        try {
            adminClient.createTopics(List.of(newTopic)).all().get(KAFKA_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create Kafka topic", ex);
        }
    }

    private NewTopic mapToNewTopic(KafkaTopic topic) {
        return new NewTopic(topic.name(), topic.partitions(), 1);
    }

    @Generated
    KafkaTopicConfigurer() {
    }
}

