/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.kafka.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.utility.DockerImageName;
import pl.netroute.hussar.core.configuration.api.ConfigurationRegistry;
import pl.netroute.hussar.core.configuration.api.DefaultConfigurationRegistry;
import pl.netroute.hussar.core.docker.DockerImageResolver;
import pl.netroute.hussar.core.docker.api.DockerRegistry;
import pl.netroute.hussar.core.service.ServiceConfigureContext;
import pl.netroute.hussar.core.service.api.BaseDockerServiceConfigurer;
import pl.netroute.hussar.core.service.registerer.EndpointRegisterer;
import pl.netroute.hussar.core.service.resolver.ServiceNameResolver;
import pl.netroute.hussar.service.kafka.api.KafkaDockerService;
import pl.netroute.hussar.service.kafka.api.KafkaDockerServiceConfig;
import pl.netroute.hussar.service.kafka.api.KafkaKraftModeConfigurer;
import pl.netroute.hussar.service.kafka.api.KafkaListener;
import pl.netroute.hussar.service.kafka.api.KafkaListenerConfigurer;
import pl.netroute.hussar.service.kafka.api.KafkaTopic;
import pl.netroute.hussar.service.kafka.api.KafkaTopicAutoCreationConfigurer;
import pl.netroute.hussar.service.kafka.api.KafkaTopicConfigurer;

public class KafkaDockerServiceConfigurer
extends BaseDockerServiceConfigurer<KafkaDockerService> {
    private static final String DOCKER_IMAGE = "confluentinc/cp-kafka";
    private static final String SERVICE = "kafka_service";
    private static final String KAFKA_SCHEME = "";
    boolean kraftMode;
    boolean topicAutoCreation;
    protected final Set<KafkaTopic> topics;

    public KafkaDockerService configure(@NonNull ServiceConfigureContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        DockerRegistry dockerRegistry = context.dockerRegistry();
        DockerImageName dockerImage = DockerImageResolver.resolve((DockerRegistry)dockerRegistry, (String)DOCKER_IMAGE, (String)this.dockerImageVersion);
        KafkaDockerServiceConfig config = this.createConfig(dockerImage);
        KafkaContainer container = this.createContainer(dockerImage);
        DefaultConfigurationRegistry configurationRegistry = new DefaultConfigurationRegistry();
        EndpointRegisterer endpointRegisterer = new EndpointRegisterer((ConfigurationRegistry)configurationRegistry);
        KafkaListenerConfigurer listenerConfigurer = new KafkaListenerConfigurer();
        KafkaTopicConfigurer topicConfigurer = new KafkaTopicConfigurer();
        KafkaTopicAutoCreationConfigurer topicAutoCreationConfigurer = new KafkaTopicAutoCreationConfigurer();
        KafkaKraftModeConfigurer kraftModeConfigurer = new KafkaKraftModeConfigurer();
        return new KafkaDockerService(container, config, (ConfigurationRegistry)configurationRegistry, endpointRegisterer, listenerConfigurer, topicConfigurer, topicAutoCreationConfigurer, kraftModeConfigurer);
    }

    private KafkaContainer createContainer(DockerImageName dockerImage) {
        return new KafkaContainer(this, dockerImage){

            public String getBootstrapServers() {
                KafkaListener externalListener = KafkaListenerConfigurer.EXTERNAL_LISTENER;
                String host = this.getHost();
                Integer port = this.getMappedPort(externalListener.port());
                return KafkaListener.newListener(externalListener, host, port).configuredListener();
            }
        };
    }

    private KafkaDockerServiceConfig createConfig(DockerImageName dockerImage) {
        String resolvedName = ServiceNameResolver.resolve((String)SERVICE, (String)this.name);
        return ((KafkaDockerServiceConfig.KafkaDockerServiceConfigBuilder)((KafkaDockerServiceConfig.KafkaDockerServiceConfigBuilder)((KafkaDockerServiceConfig.KafkaDockerServiceConfigBuilder)((Object)((KafkaDockerServiceConfig.KafkaDockerServiceConfigBuilder)((Object)((KafkaDockerServiceConfig.KafkaDockerServiceConfigBuilder)((KafkaDockerServiceConfig.KafkaDockerServiceConfigBuilder)((KafkaDockerServiceConfig.KafkaDockerServiceConfigBuilder)KafkaDockerServiceConfig.builder().name(resolvedName)).dockerImage(dockerImage.asCanonicalNameString())).scheme(KAFKA_SCHEME)).topics(this.topics))).kraftMode(this.kraftMode))).topicAutoCreation(this.topicAutoCreation).registerEndpointUnderProperties(this.registerEndpointUnderProperties)).registerEndpointUnderEnvironmentVariables(this.registerEndpointUnderEnvironmentVariables)).build();
    }

    @Generated
    protected KafkaDockerServiceConfigurer(KafkaDockerServiceConfigurerBuilder<?, ?> b) {
        super(b);
        Set<Object> topics;
        this.kraftMode = b.kraftMode;
        this.topicAutoCreation = b.topicAutoCreation;
        switch (b.topics == null ? 0 : b.topics.size()) {
            case 0: {
                topics = Collections.emptySet();
                break;
            }
            case 1: {
                topics = Collections.singleton(b.topics.get(0));
                break;
            }
            default: {
                topics = new LinkedHashSet(b.topics.size() < 0x40000000 ? 1 + b.topics.size() + (b.topics.size() - 3) / 3 : Integer.MAX_VALUE);
                topics.addAll(b.topics);
                topics = Collections.unmodifiableSet(topics);
            }
        }
        this.topics = topics;
    }

    @Generated
    public static KafkaDockerServiceConfigurerBuilder<?, ?> newInstance() {
        return new KafkaDockerServiceConfigurerBuilderImpl();
    }

    @Generated
    public static abstract class KafkaDockerServiceConfigurerBuilder<C extends KafkaDockerServiceConfigurer, B extends KafkaDockerServiceConfigurerBuilder<C, B>>
    extends BaseDockerServiceConfigurer.BaseDockerServiceConfigurerBuilder<KafkaDockerService, C, B> {
        @Generated
        private boolean kraftMode;
        @Generated
        private boolean topicAutoCreation;
        @Generated
        private ArrayList<KafkaTopic> topics;

        @Generated
        public B kraftMode(boolean kraftMode) {
            this.kraftMode = kraftMode;
            return (B)this.self();
        }

        @Generated
        public B topicAutoCreation(boolean topicAutoCreation) {
            this.topicAutoCreation = topicAutoCreation;
            return (B)this.self();
        }

        @Generated
        public B topic(KafkaTopic topic) {
            if (this.topics == null) {
                this.topics = new ArrayList();
            }
            this.topics.add(topic);
            return (B)this.self();
        }

        @Generated
        public B topics(Collection<? extends KafkaTopic> topics) {
            if (topics == null) {
                throw new NullPointerException("topics cannot be null");
            }
            if (this.topics == null) {
                this.topics = new ArrayList();
            }
            this.topics.addAll(topics);
            return (B)this.self();
        }

        @Generated
        public B clearTopics() {
            if (this.topics != null) {
                this.topics.clear();
            }
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C done();

        @Generated
        public String toString() {
            return "KafkaDockerServiceConfigurer.KafkaDockerServiceConfigurerBuilder(super=" + super.toString() + ", kraftMode=" + this.kraftMode + ", topicAutoCreation=" + this.topicAutoCreation + ", topics=" + String.valueOf(this.topics) + ")";
        }
    }

    @Generated
    private static final class KafkaDockerServiceConfigurerBuilderImpl
    extends KafkaDockerServiceConfigurerBuilder<KafkaDockerServiceConfigurer, KafkaDockerServiceConfigurerBuilderImpl> {
        @Generated
        private KafkaDockerServiceConfigurerBuilderImpl() {
        }

        @Override
        @Generated
        protected KafkaDockerServiceConfigurerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public KafkaDockerServiceConfigurer done() {
            return new KafkaDockerServiceConfigurer(this);
        }
    }
}

