/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.kafka.api;

import lombok.Generated;
import lombok.NonNull;
import pl.netroute.hussar.core.api.InternalUseOnly;

@InternalUseOnly
record KafkaListener(@NonNull String name, @NonNull String host, @NonNull String protocol, int port) {
    private static final String LISTENER_TEMPLATE = "%s://%s:%d";
    private static final String LISTENER_PROTOCOL_TEMPLATE = "%s:%s";

    @Generated
    public KafkaListener(@NonNull String name, @NonNull String host, @NonNull String protocol, int port) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
    }

    String configuredListener() {
        return LISTENER_TEMPLATE.formatted(this.name, this.host, this.port);
    }

    String configuredProtocol() {
        return LISTENER_PROTOCOL_TEMPLATE.formatted(this.name, this.protocol);
    }

    static KafkaListener newListener(@NonNull KafkaListener listener, @NonNull String host, int port) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        String name = listener.name();
        String protocol = listener.protocol();
        return new KafkaListener(name, host, protocol, port);
    }
}

