/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.testcontainers.containers.GenericContainer;
import pl.netroute.hussar.core.api.Endpoint;
import pl.netroute.hussar.core.api.configuration.ConfigurationRegistry;
import pl.netroute.hussar.core.api.service.Service;
import pl.netroute.hussar.core.api.service.ServiceStartupContext;
import pl.netroute.hussar.core.helper.EndpointHelper;
import pl.netroute.hussar.core.service.BaseDockerService;
import pl.netroute.hussar.core.service.BaseDockerServiceConfig;
import pl.netroute.hussar.core.service.registerer.EndpointRegisterer;
import pl.netroute.hussar.service.rabbitmq.RabbitMQCredentialsRegisterer;
import pl.netroute.hussar.service.rabbitmq.RabbitMQDockerServiceConfig;
import pl.netroute.hussar.service.rabbitmq.RabbitMQQueueConfigurer;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQCredentials;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQQueue;

public class RabbitMQDockerService
extends BaseDockerService<RabbitMQDockerServiceConfig> {
    private static final int LISTENING_PORT = 5672;
    private static final int MANAGEMENT_API_LISTENING_PORT = 15672;
    private static final String RABBITMQ_DEFAULT_USER_ENV = "RABBITMQ_DEFAULT_USER";
    private static final String RABBITMQ_DEFAULT_PASS_ENV = "RABBITMQ_DEFAULT_PASS";
    private static final String RABBITMQ_USERNAME = "guest";
    private static final String RABBITMQ_PASSWORD = "password";
    private static final String RABBITMQ_MANAGEMENT_VERSION = "management";
    private final RabbitMQCredentialsRegisterer credentialsRegisterer;
    private final RabbitMQQueueConfigurer queueConfigurer;
    private final RabbitMQCredentials credentials;

    RabbitMQDockerService(@NonNull GenericContainer<?> container, @NonNull RabbitMQDockerServiceConfig config, @NonNull ConfigurationRegistry configurationRegistry, @NonNull EndpointRegisterer endpointRegisterer, @NonNull RabbitMQCredentialsRegisterer credentialsRegisterer, @NonNull RabbitMQQueueConfigurer queueConfigurer) {
        super(container, (BaseDockerServiceConfig)config, configurationRegistry, endpointRegisterer);
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (configurationRegistry == null) {
            throw new NullPointerException("configurationRegistry is marked non-null but is null");
        }
        if (endpointRegisterer == null) {
            throw new NullPointerException("endpointRegisterer is marked non-null but is null");
        }
        if (credentialsRegisterer == null) {
            throw new NullPointerException("credentialsRegisterer is marked non-null but is null");
        }
        if (queueConfigurer == null) {
            throw new NullPointerException("queueConfigurer is marked non-null but is null");
        }
        this.credentialsRegisterer = credentialsRegisterer;
        this.queueConfigurer = queueConfigurer;
        this.credentials = new RabbitMQCredentials(RABBITMQ_USERNAME, RABBITMQ_PASSWORD);
    }

    public List<Endpoint> getEndpoints() {
        List endpoints = super.getEndpoints();
        if (this.isManagementApiSupported()) {
            Integer managementApiPort = this.container.getMappedPort(15672);
            return endpoints.stream().filter(endpoint -> endpoint.port() != managementApiPort.intValue()).toList();
        }
        return endpoints;
    }

    protected void configureContainer(GenericContainer<?> container) {
        super.configureContainer(container);
        this.configureExposedPorts(container);
        container.withEnv(RABBITMQ_DEFAULT_USER_ENV, RABBITMQ_USERNAME);
        container.withEnv(RABBITMQ_DEFAULT_PASS_ENV, RABBITMQ_PASSWORD);
    }

    protected void doAfterServiceStartup(ServiceStartupContext context) {
        super.doAfterServiceStartup(context);
        ConnectionFactory connectionFactory = this.createConnectionFactory();
        this.configureQueues(connectionFactory);
        this.registerCredentialsUnderProperties();
        this.registerCredentialsUnderEnvironmentVariables();
    }

    public RabbitMQCredentials getCredentials() {
        return this.credentials;
    }

    public Optional<Endpoint> getManagementEndpoint() {
        if (this.isManagementApiSupported()) {
            String host = this.container.getHost();
            Integer port = this.container.getMappedPort(15672);
            Endpoint endpoint = Endpoint.of((String)"http://", (String)host, (int)port);
            return Optional.of(endpoint);
        }
        return Optional.empty();
    }

    private ConnectionFactory createConnectionFactory() {
        Endpoint endpoint = EndpointHelper.getAnyEndpointOrFail((Service)this);
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(endpoint.host());
        connectionFactory.setPort(endpoint.port());
        connectionFactory.setUsername(this.credentials.username());
        connectionFactory.setPassword(this.credentials.password());
        return connectionFactory;
    }

    private void configureQueues(ConnectionFactory connectionFactory) {
        Set<RabbitMQQueue> queues = ((RabbitMQDockerServiceConfig)this.config).getQueues();
        queues.forEach(queue -> this.queueConfigurer.configure(connectionFactory, (RabbitMQQueue)queue));
    }

    private void configureExposedPorts(GenericContainer<?> container) {
        ArrayList<Integer> exposedPorts = new ArrayList<Integer>();
        exposedPorts.add(5672);
        if (this.isManagementApiSupported()) {
            exposedPorts.add(15672);
        }
        container.withExposedPorts(exposedPorts.toArray(new Integer[0]));
    }

    private void registerCredentialsUnderProperties() {
        ((RabbitMQDockerServiceConfig)this.config).getRegisterUsernameUnderProperties().forEach(usernameProperty -> this.credentialsRegisterer.registerUsernameUnderProperty(this.credentials, (String)usernameProperty));
        ((RabbitMQDockerServiceConfig)this.config).getRegisterPasswordUnderProperties().forEach(passwordProperty -> this.credentialsRegisterer.registerPasswordUnderProperty(this.credentials, (String)passwordProperty));
    }

    private void registerCredentialsUnderEnvironmentVariables() {
        ((RabbitMQDockerServiceConfig)this.config).getRegisterUsernameUnderEnvironmentVariables().forEach(usernameEnvVariable -> this.credentialsRegisterer.registerUsernameUnderEnvironmentVariable(this.credentials, (String)usernameEnvVariable));
        ((RabbitMQDockerServiceConfig)this.config).getRegisterPasswordUnderEnvironmentVariables().forEach(passwordEnvVariable -> this.credentialsRegisterer.registerPasswordUnderEnvironmentVariable(this.credentials, (String)passwordEnvVariable));
    }

    private boolean isManagementApiSupported() {
        String dockerImage = ((RabbitMQDockerServiceConfig)this.config).getDockerImage();
        return dockerImage.contains(RABBITMQ_MANAGEMENT_VERSION);
    }
}

