/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQQueue;

class RabbitMQQueueConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RabbitMQQueueConfigurer.class);

    RabbitMQQueueConfigurer() {
    }

    void configure(@NonNull ConnectionFactory connectionFactory, @NonNull RabbitMQQueue queue) {
        if (connectionFactory == null) {
            throw new NullPointerException("connectionFactory is marked non-null but is null");
        }
        if (queue == null) {
            throw new NullPointerException("queue is marked non-null but is null");
        }
        log.info("Creating {}", (Object)queue);
        try (Connection connection = connectionFactory.newConnection();
             Channel channel = connection.createChannel();){
            String name = queue.name();
            boolean durable = queue.durable();
            boolean exclusive = queue.exclusive();
            boolean autoDelete = queue.autoDelete();
            Map<String, Object> arguments = queue.arguments();
            channel.queueDeclare(name, durable, exclusive, autoDelete, arguments);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create RabbitMQ queue", ex);
        }
    }
}

