/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.rabbitmq;

import lombok.Generated;
import lombok.NonNull;
import pl.netroute.hussar.core.api.configuration.ConfigurationEntry;
import pl.netroute.hussar.core.api.configuration.ConfigurationRegistry;
import pl.netroute.hussar.core.api.configuration.EnvVariableConfigurationEntry;
import pl.netroute.hussar.core.api.configuration.PropertyConfigurationEntry;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQCredentials;

class RabbitMQCredentialsRegisterer {
    @NonNull
    private final ConfigurationRegistry configurationRegistry;

    void registerUsernameUnderProperty(@NonNull RabbitMQCredentials credentials, @NonNull String usernameProperty) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (usernameProperty == null) {
            throw new NullPointerException("usernameProperty is marked non-null but is null");
        }
        PropertyConfigurationEntry property = new PropertyConfigurationEntry(usernameProperty, credentials.username());
        this.configurationRegistry.register((ConfigurationEntry)property);
    }

    void registerPasswordUnderProperty(@NonNull RabbitMQCredentials credentials, @NonNull String passwordProperty) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (passwordProperty == null) {
            throw new NullPointerException("passwordProperty is marked non-null but is null");
        }
        PropertyConfigurationEntry property = new PropertyConfigurationEntry(passwordProperty, credentials.password());
        this.configurationRegistry.register((ConfigurationEntry)property);
    }

    void registerUsernameUnderEnvironmentVariable(@NonNull RabbitMQCredentials credentials, @NonNull String usernameEnvVariable) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (usernameEnvVariable == null) {
            throw new NullPointerException("usernameEnvVariable is marked non-null but is null");
        }
        EnvVariableConfigurationEntry envVariable = new EnvVariableConfigurationEntry(usernameEnvVariable, credentials.username());
        this.configurationRegistry.register((ConfigurationEntry)envVariable);
    }

    void registerPasswordUnderEnvironmentVariable(@NonNull RabbitMQCredentials credentials, @NonNull String passwordEnvVariable) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (passwordEnvVariable == null) {
            throw new NullPointerException("passwordEnvVariable is marked non-null but is null");
        }
        EnvVariableConfigurationEntry envVariable = new EnvVariableConfigurationEntry(passwordEnvVariable, credentials.password());
        this.configurationRegistry.register((ConfigurationEntry)envVariable);
    }

    @Generated
    RabbitMQCredentialsRegisterer(@NonNull ConfigurationRegistry configurationRegistry) {
        if (configurationRegistry == null) {
            throw new NullPointerException("configurationRegistry is marked non-null but is null");
        }
        this.configurationRegistry = configurationRegistry;
    }
}

