/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.rabbitmq.api;

import com.rabbitmq.client.ConnectionFactory;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.testcontainers.containers.GenericContainer;
import pl.netroute.hussar.core.api.Endpoint;
import pl.netroute.hussar.core.configuration.api.ConfigurationRegistry;
import pl.netroute.hussar.core.docker.api.DockerNetwork;
import pl.netroute.hussar.core.helper.EndpointHelper;
import pl.netroute.hussar.core.network.api.NetworkConfigurer;
import pl.netroute.hussar.core.service.ServiceStartupContext;
import pl.netroute.hussar.core.service.api.BaseDockerService;
import pl.netroute.hussar.core.service.api.BaseDockerServiceConfig;
import pl.netroute.hussar.core.service.api.Service;
import pl.netroute.hussar.core.service.registerer.EndpointRegisterer;
import pl.netroute.hussar.service.rabbitmq.api.ManagementApiResolver;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQCredentials;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQCredentialsRegisterer;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQDockerServiceConfig;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQQueue;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQQueueConfigurer;

public class RabbitMQDockerService
extends BaseDockerService<RabbitMQDockerServiceConfig> {
    private static final int LISTENING_PORT = 5672;
    private static final int MANAGEMENT_API_LISTENING_PORT = 15672;
    private static final String RABBITMQ_DEFAULT_USER_ENV = "RABBITMQ_DEFAULT_USER";
    private static final String RABBITMQ_DEFAULT_PASS_ENV = "RABBITMQ_DEFAULT_PASS";
    private static final String RABBITMQ_USERNAME = "guest";
    private static final String RABBITMQ_PASSWORD = "password";
    @NonNull
    private final RabbitMQCredentialsRegisterer credentialsRegisterer;
    @NonNull
    private final RabbitMQQueueConfigurer queueConfigurer;
    @NonNull
    private final RabbitMQCredentials credentials;

    RabbitMQDockerService(@NonNull GenericContainer<?> container, @NonNull DockerNetwork dockerNetwork, @NonNull RabbitMQDockerServiceConfig config, @NonNull ConfigurationRegistry configurationRegistry, @NonNull EndpointRegisterer endpointRegisterer, @NonNull NetworkConfigurer networkConfigurer, @NonNull RabbitMQCredentialsRegisterer credentialsRegisterer, @NonNull RabbitMQQueueConfigurer queueConfigurer) {
        super(container, dockerNetwork, (BaseDockerServiceConfig)config, configurationRegistry, endpointRegisterer, networkConfigurer);
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        if (dockerNetwork == null) {
            throw new NullPointerException("dockerNetwork is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (configurationRegistry == null) {
            throw new NullPointerException("configurationRegistry is marked non-null but is null");
        }
        if (endpointRegisterer == null) {
            throw new NullPointerException("endpointRegisterer is marked non-null but is null");
        }
        if (networkConfigurer == null) {
            throw new NullPointerException("networkConfigurer is marked non-null but is null");
        }
        if (credentialsRegisterer == null) {
            throw new NullPointerException("credentialsRegisterer is marked non-null but is null");
        }
        if (queueConfigurer == null) {
            throw new NullPointerException("queueConfigurer is marked non-null but is null");
        }
        this.credentialsRegisterer = credentialsRegisterer;
        this.queueConfigurer = queueConfigurer;
        this.credentials = new RabbitMQCredentials(RABBITMQ_USERNAME, RABBITMQ_PASSWORD);
    }

    protected List<Endpoint> getInternalEndpoints() {
        List endpoints = super.getInternalEndpoints();
        if (ManagementApiResolver.isSupported((RabbitMQDockerServiceConfig)this.config)) {
            return endpoints.stream().filter(endpoint -> endpoint.port() != 15672).toList();
        }
        return endpoints;
    }

    protected List<Integer> getInternalPorts() {
        if (ManagementApiResolver.isSupported((RabbitMQDockerServiceConfig)this.config)) {
            return List.of(Integer.valueOf(5672), Integer.valueOf(15672));
        }
        return List.of(Integer.valueOf(5672));
    }

    protected void configureEnvVariables(GenericContainer<?> container) {
        super.configureEnvVariables(container);
        container.withEnv(RABBITMQ_DEFAULT_USER_ENV, RABBITMQ_USERNAME);
        container.withEnv(RABBITMQ_DEFAULT_PASS_ENV, RABBITMQ_PASSWORD);
    }

    protected void doAfterServiceStartup(ServiceStartupContext context) {
        super.doAfterServiceStartup(context);
        ConnectionFactory connectionFactory = this.createConnectionFactory();
        this.configureQueues(connectionFactory);
        this.registerCredentialsUnderProperties();
        this.registerCredentialsUnderEnvironmentVariables();
        this.registerManagementEndpointUnderProperties();
        this.registerManagementEndpointUnderEnvironmentVariables();
    }

    public Optional<Endpoint> getManagementEndpoint() {
        if (ManagementApiResolver.isSupported((RabbitMQDockerServiceConfig)this.config)) {
            String host = this.container.getHost();
            Integer port = this.container.getMappedPort(15672);
            Endpoint endpoint = Endpoint.of((String)"http://", (String)host, (int)port);
            return Optional.of(endpoint);
        }
        return Optional.empty();
    }

    private ConnectionFactory createConnectionFactory() {
        Endpoint endpoint = EndpointHelper.getAnyEndpointOrFail((Service)this);
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(endpoint.host());
        connectionFactory.setPort(endpoint.port());
        connectionFactory.setUsername(this.credentials.username());
        connectionFactory.setPassword(this.credentials.password());
        return connectionFactory;
    }

    private void configureQueues(ConnectionFactory connectionFactory) {
        Set<RabbitMQQueue> queues = ((RabbitMQDockerServiceConfig)this.config).getQueues();
        queues.forEach(queue -> this.queueConfigurer.configure(connectionFactory, (RabbitMQQueue)queue));
    }

    private void registerCredentialsUnderProperties() {
        ((RabbitMQDockerServiceConfig)this.config).getRegisterUsernameUnderProperties().forEach(usernameProperty -> this.credentialsRegisterer.registerUsernameUnderProperty(this.credentials, (String)usernameProperty));
        ((RabbitMQDockerServiceConfig)this.config).getRegisterPasswordUnderProperties().forEach(passwordProperty -> this.credentialsRegisterer.registerPasswordUnderProperty(this.credentials, (String)passwordProperty));
    }

    private void registerCredentialsUnderEnvironmentVariables() {
        ((RabbitMQDockerServiceConfig)this.config).getRegisterUsernameUnderEnvironmentVariables().forEach(usernameEnvVariable -> this.credentialsRegisterer.registerUsernameUnderEnvironmentVariable(this.credentials, (String)usernameEnvVariable));
        ((RabbitMQDockerServiceConfig)this.config).getRegisterPasswordUnderEnvironmentVariables().forEach(passwordEnvVariable -> this.credentialsRegisterer.registerPasswordUnderEnvironmentVariable(this.credentials, (String)passwordEnvVariable));
    }

    private void registerManagementEndpointUnderProperties() {
        if (ManagementApiResolver.isSupported((RabbitMQDockerServiceConfig)this.config)) {
            List endpoints = this.getManagementEndpoint().map(List::of).orElse(List.of());
            ((RabbitMQDockerServiceConfig)this.config).getRegisterManagementEndpointUnderProperties().forEach(endpointProperty -> this.endpointRegisterer.registerUnderProperty(endpoints, endpointProperty));
        }
    }

    private void registerManagementEndpointUnderEnvironmentVariables() {
        if (ManagementApiResolver.isSupported((RabbitMQDockerServiceConfig)this.config)) {
            List endpoints = this.getManagementEndpoint().map(List::of).orElse(List.of());
            ((RabbitMQDockerServiceConfig)this.config).getRegisterManagementEndpointUnderEnvironmentVariables().forEach(endpointEnvVariable -> this.endpointRegisterer.registerUnderEnvironmentVariable(endpoints, endpointEnvVariable));
        }
    }

    @NonNull
    @Generated
    public RabbitMQCredentials getCredentials() {
        return this.credentials;
    }
}

