/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.rabbitmq.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;
import pl.netroute.hussar.core.configuration.api.ConfigurationRegistry;
import pl.netroute.hussar.core.configuration.api.DefaultConfigurationRegistry;
import pl.netroute.hussar.core.docker.DockerImageResolver;
import pl.netroute.hussar.core.docker.DockerRegistryResolver;
import pl.netroute.hussar.core.docker.GenericContainerFactory;
import pl.netroute.hussar.core.docker.api.DockerNetwork;
import pl.netroute.hussar.core.docker.api.DockerRegistry;
import pl.netroute.hussar.core.network.api.NetworkConfigurer;
import pl.netroute.hussar.core.service.ServiceConfigureContext;
import pl.netroute.hussar.core.service.api.BaseDockerServiceConfigurer;
import pl.netroute.hussar.core.service.registerer.EndpointRegisterer;
import pl.netroute.hussar.core.service.resolver.ServiceNameResolver;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQCredentialsRegisterer;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQDockerService;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQDockerServiceConfig;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQQueue;
import pl.netroute.hussar.service.rabbitmq.api.RabbitMQQueueConfigurer;

public class RabbitMQDockerServiceConfigurer
extends BaseDockerServiceConfigurer<RabbitMQDockerService> {
    private static final String DOCKER_IMAGE = "rabbitmq";
    private static final String SERVICE = "rabbitmq_service";
    private static final String SCHEME = "amqp://";
    private final Set<RabbitMQQueue> queues;
    private final Set<String> registerUsernameUnderProperties;
    private final Set<String> registerUsernameUnderEnvironmentVariables;
    private final Set<String> registerPasswordUnderProperties;
    private final Set<String> registerPasswordUnderEnvironmentVariables;
    private final Set<String> registerManagementEndpointUnderProperties;
    private final Set<String> registerManagementEndpointUnderEnvironmentVariables;

    public RabbitMQDockerService configure(@NonNull ServiceConfigureContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        DockerRegistry resolvedDockerRegistry = DockerRegistryResolver.resolve((DockerRegistry)this.dockerRegistry, (ServiceConfigureContext)context);
        DockerNetwork dockerNetwork = context.dockerNetwork();
        NetworkConfigurer networkConfigurer = context.networkConfigurer();
        DockerImageName dockerImage = DockerImageResolver.resolve((DockerRegistry)resolvedDockerRegistry, (String)DOCKER_IMAGE, (String)this.dockerImageVersion);
        RabbitMQDockerServiceConfig config = this.createConfig(dockerImage);
        GenericContainer container = GenericContainerFactory.create((DockerImageName)dockerImage);
        DefaultConfigurationRegistry configurationRegistry = new DefaultConfigurationRegistry();
        EndpointRegisterer endpointRegisterer = new EndpointRegisterer((ConfigurationRegistry)configurationRegistry);
        RabbitMQCredentialsRegisterer credentialsRegisterer = new RabbitMQCredentialsRegisterer((ConfigurationRegistry)configurationRegistry);
        RabbitMQQueueConfigurer queueConfigurer = new RabbitMQQueueConfigurer();
        return new RabbitMQDockerService(container, dockerNetwork, config, (ConfigurationRegistry)configurationRegistry, endpointRegisterer, networkConfigurer, credentialsRegisterer, queueConfigurer);
    }

    private RabbitMQDockerServiceConfig createConfig(DockerImageName dockerImage) {
        String resolvedName = ServiceNameResolver.resolve((String)SERVICE, (String)this.name);
        return ((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((Object)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((Object)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((Object)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((Object)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((Object)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((Object)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)((RabbitMQDockerServiceConfig.RabbitMQDockerServiceConfigBuilder)RabbitMQDockerServiceConfig.builder().name(resolvedName)).dockerImage(dockerImage.asCanonicalNameString())).scheme(SCHEME)).queues(this.queues))).registerUsernameUnderProperties(this.registerUsernameUnderProperties))).registerUsernameUnderEnvironmentVariables(this.registerUsernameUnderEnvironmentVariables))).registerPasswordUnderProperties(this.registerPasswordUnderProperties))).registerPasswordUnderEnvironmentVariables(this.registerPasswordUnderEnvironmentVariables).registerEndpointUnderProperties(this.registerEndpointUnderProperties)).registerEndpointUnderEnvironmentVariables(this.registerEndpointUnderEnvironmentVariables)).registerManagementEndpointUnderProperties(this.registerManagementEndpointUnderProperties))).registerManagementEndpointUnderEnvironmentVariables(this.registerManagementEndpointUnderEnvironmentVariables))).build();
    }

    @Generated
    protected RabbitMQDockerServiceConfigurer(RabbitMQDockerServiceConfigurerBuilder<?, ?> b) {
        super(b);
        Set<Object> registerManagementEndpointUnderEnvironmentVariables;
        Set<Object> registerManagementEndpointUnderProperties;
        Set<Object> registerPasswordUnderEnvironmentVariables;
        Set<Object> registerPasswordUnderProperties;
        Set<Object> registerUsernameUnderEnvironmentVariables;
        Set<Object> registerUsernameUnderProperties;
        Set<Object> queues;
        switch (b.queues == null ? 0 : b.queues.size()) {
            case 0: {
                queues = Collections.emptySet();
                break;
            }
            case 1: {
                queues = Collections.singleton(b.queues.get(0));
                break;
            }
            default: {
                queues = new LinkedHashSet(b.queues.size() < 0x40000000 ? 1 + b.queues.size() + (b.queues.size() - 3) / 3 : Integer.MAX_VALUE);
                queues.addAll(b.queues);
                queues = Collections.unmodifiableSet(queues);
            }
        }
        this.queues = queues;
        switch (b.registerUsernameUnderProperties == null ? 0 : b.registerUsernameUnderProperties.size()) {
            case 0: {
                registerUsernameUnderProperties = Collections.emptySet();
                break;
            }
            case 1: {
                registerUsernameUnderProperties = Collections.singleton(b.registerUsernameUnderProperties.get(0));
                break;
            }
            default: {
                registerUsernameUnderProperties = new LinkedHashSet(b.registerUsernameUnderProperties.size() < 0x40000000 ? 1 + b.registerUsernameUnderProperties.size() + (b.registerUsernameUnderProperties.size() - 3) / 3 : Integer.MAX_VALUE);
                registerUsernameUnderProperties.addAll(b.registerUsernameUnderProperties);
                registerUsernameUnderProperties = Collections.unmodifiableSet(registerUsernameUnderProperties);
            }
        }
        this.registerUsernameUnderProperties = registerUsernameUnderProperties;
        switch (b.registerUsernameUnderEnvironmentVariables == null ? 0 : b.registerUsernameUnderEnvironmentVariables.size()) {
            case 0: {
                registerUsernameUnderEnvironmentVariables = Collections.emptySet();
                break;
            }
            case 1: {
                registerUsernameUnderEnvironmentVariables = Collections.singleton(b.registerUsernameUnderEnvironmentVariables.get(0));
                break;
            }
            default: {
                registerUsernameUnderEnvironmentVariables = new LinkedHashSet(b.registerUsernameUnderEnvironmentVariables.size() < 0x40000000 ? 1 + b.registerUsernameUnderEnvironmentVariables.size() + (b.registerUsernameUnderEnvironmentVariables.size() - 3) / 3 : Integer.MAX_VALUE);
                registerUsernameUnderEnvironmentVariables.addAll(b.registerUsernameUnderEnvironmentVariables);
                registerUsernameUnderEnvironmentVariables = Collections.unmodifiableSet(registerUsernameUnderEnvironmentVariables);
            }
        }
        this.registerUsernameUnderEnvironmentVariables = registerUsernameUnderEnvironmentVariables;
        switch (b.registerPasswordUnderProperties == null ? 0 : b.registerPasswordUnderProperties.size()) {
            case 0: {
                registerPasswordUnderProperties = Collections.emptySet();
                break;
            }
            case 1: {
                registerPasswordUnderProperties = Collections.singleton(b.registerPasswordUnderProperties.get(0));
                break;
            }
            default: {
                registerPasswordUnderProperties = new LinkedHashSet(b.registerPasswordUnderProperties.size() < 0x40000000 ? 1 + b.registerPasswordUnderProperties.size() + (b.registerPasswordUnderProperties.size() - 3) / 3 : Integer.MAX_VALUE);
                registerPasswordUnderProperties.addAll(b.registerPasswordUnderProperties);
                registerPasswordUnderProperties = Collections.unmodifiableSet(registerPasswordUnderProperties);
            }
        }
        this.registerPasswordUnderProperties = registerPasswordUnderProperties;
        switch (b.registerPasswordUnderEnvironmentVariables == null ? 0 : b.registerPasswordUnderEnvironmentVariables.size()) {
            case 0: {
                registerPasswordUnderEnvironmentVariables = Collections.emptySet();
                break;
            }
            case 1: {
                registerPasswordUnderEnvironmentVariables = Collections.singleton(b.registerPasswordUnderEnvironmentVariables.get(0));
                break;
            }
            default: {
                registerPasswordUnderEnvironmentVariables = new LinkedHashSet(b.registerPasswordUnderEnvironmentVariables.size() < 0x40000000 ? 1 + b.registerPasswordUnderEnvironmentVariables.size() + (b.registerPasswordUnderEnvironmentVariables.size() - 3) / 3 : Integer.MAX_VALUE);
                registerPasswordUnderEnvironmentVariables.addAll(b.registerPasswordUnderEnvironmentVariables);
                registerPasswordUnderEnvironmentVariables = Collections.unmodifiableSet(registerPasswordUnderEnvironmentVariables);
            }
        }
        this.registerPasswordUnderEnvironmentVariables = registerPasswordUnderEnvironmentVariables;
        switch (b.registerManagementEndpointUnderProperties == null ? 0 : b.registerManagementEndpointUnderProperties.size()) {
            case 0: {
                registerManagementEndpointUnderProperties = Collections.emptySet();
                break;
            }
            case 1: {
                registerManagementEndpointUnderProperties = Collections.singleton(b.registerManagementEndpointUnderProperties.get(0));
                break;
            }
            default: {
                registerManagementEndpointUnderProperties = new LinkedHashSet(b.registerManagementEndpointUnderProperties.size() < 0x40000000 ? 1 + b.registerManagementEndpointUnderProperties.size() + (b.registerManagementEndpointUnderProperties.size() - 3) / 3 : Integer.MAX_VALUE);
                registerManagementEndpointUnderProperties.addAll(b.registerManagementEndpointUnderProperties);
                registerManagementEndpointUnderProperties = Collections.unmodifiableSet(registerManagementEndpointUnderProperties);
            }
        }
        this.registerManagementEndpointUnderProperties = registerManagementEndpointUnderProperties;
        switch (b.registerManagementEndpointUnderEnvironmentVariables == null ? 0 : b.registerManagementEndpointUnderEnvironmentVariables.size()) {
            case 0: {
                registerManagementEndpointUnderEnvironmentVariables = Collections.emptySet();
                break;
            }
            case 1: {
                registerManagementEndpointUnderEnvironmentVariables = Collections.singleton(b.registerManagementEndpointUnderEnvironmentVariables.get(0));
                break;
            }
            default: {
                registerManagementEndpointUnderEnvironmentVariables = new LinkedHashSet(b.registerManagementEndpointUnderEnvironmentVariables.size() < 0x40000000 ? 1 + b.registerManagementEndpointUnderEnvironmentVariables.size() + (b.registerManagementEndpointUnderEnvironmentVariables.size() - 3) / 3 : Integer.MAX_VALUE);
                registerManagementEndpointUnderEnvironmentVariables.addAll(b.registerManagementEndpointUnderEnvironmentVariables);
                registerManagementEndpointUnderEnvironmentVariables = Collections.unmodifiableSet(registerManagementEndpointUnderEnvironmentVariables);
            }
        }
        this.registerManagementEndpointUnderEnvironmentVariables = registerManagementEndpointUnderEnvironmentVariables;
    }

    @Generated
    public static RabbitMQDockerServiceConfigurerBuilder<?, ?> newInstance() {
        return new RabbitMQDockerServiceConfigurerBuilderImpl();
    }

    @Generated
    public static abstract class RabbitMQDockerServiceConfigurerBuilder<C extends RabbitMQDockerServiceConfigurer, B extends RabbitMQDockerServiceConfigurerBuilder<C, B>>
    extends BaseDockerServiceConfigurer.BaseDockerServiceConfigurerBuilder<RabbitMQDockerService, C, B> {
        @Generated
        private ArrayList<RabbitMQQueue> queues;
        @Generated
        private ArrayList<String> registerUsernameUnderProperties;
        @Generated
        private ArrayList<String> registerUsernameUnderEnvironmentVariables;
        @Generated
        private ArrayList<String> registerPasswordUnderProperties;
        @Generated
        private ArrayList<String> registerPasswordUnderEnvironmentVariables;
        @Generated
        private ArrayList<String> registerManagementEndpointUnderProperties;
        @Generated
        private ArrayList<String> registerManagementEndpointUnderEnvironmentVariables;

        @Generated
        public B queue(RabbitMQQueue queue) {
            if (this.queues == null) {
                this.queues = new ArrayList();
            }
            this.queues.add(queue);
            return (B)this.self();
        }

        @Generated
        public B queues(Collection<? extends RabbitMQQueue> queues) {
            if (queues == null) {
                throw new NullPointerException("queues cannot be null");
            }
            if (this.queues == null) {
                this.queues = new ArrayList();
            }
            this.queues.addAll(queues);
            return (B)this.self();
        }

        @Generated
        public B clearQueues() {
            if (this.queues != null) {
                this.queues.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderProperty(String registerUsernameUnderProperty) {
            if (this.registerUsernameUnderProperties == null) {
                this.registerUsernameUnderProperties = new ArrayList();
            }
            this.registerUsernameUnderProperties.add(registerUsernameUnderProperty);
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderProperties(Collection<? extends String> registerUsernameUnderProperties) {
            if (registerUsernameUnderProperties == null) {
                throw new NullPointerException("registerUsernameUnderProperties cannot be null");
            }
            if (this.registerUsernameUnderProperties == null) {
                this.registerUsernameUnderProperties = new ArrayList();
            }
            this.registerUsernameUnderProperties.addAll(registerUsernameUnderProperties);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterUsernameUnderProperties() {
            if (this.registerUsernameUnderProperties != null) {
                this.registerUsernameUnderProperties.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderEnvironmentVariable(String registerUsernameUnderEnvironmentVariable) {
            if (this.registerUsernameUnderEnvironmentVariables == null) {
                this.registerUsernameUnderEnvironmentVariables = new ArrayList();
            }
            this.registerUsernameUnderEnvironmentVariables.add(registerUsernameUnderEnvironmentVariable);
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderEnvironmentVariables(Collection<? extends String> registerUsernameUnderEnvironmentVariables) {
            if (registerUsernameUnderEnvironmentVariables == null) {
                throw new NullPointerException("registerUsernameUnderEnvironmentVariables cannot be null");
            }
            if (this.registerUsernameUnderEnvironmentVariables == null) {
                this.registerUsernameUnderEnvironmentVariables = new ArrayList();
            }
            this.registerUsernameUnderEnvironmentVariables.addAll(registerUsernameUnderEnvironmentVariables);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterUsernameUnderEnvironmentVariables() {
            if (this.registerUsernameUnderEnvironmentVariables != null) {
                this.registerUsernameUnderEnvironmentVariables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderProperty(String registerPasswordUnderProperty) {
            if (this.registerPasswordUnderProperties == null) {
                this.registerPasswordUnderProperties = new ArrayList();
            }
            this.registerPasswordUnderProperties.add(registerPasswordUnderProperty);
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderProperties(Collection<? extends String> registerPasswordUnderProperties) {
            if (registerPasswordUnderProperties == null) {
                throw new NullPointerException("registerPasswordUnderProperties cannot be null");
            }
            if (this.registerPasswordUnderProperties == null) {
                this.registerPasswordUnderProperties = new ArrayList();
            }
            this.registerPasswordUnderProperties.addAll(registerPasswordUnderProperties);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterPasswordUnderProperties() {
            if (this.registerPasswordUnderProperties != null) {
                this.registerPasswordUnderProperties.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderEnvironmentVariable(String registerPasswordUnderEnvironmentVariable) {
            if (this.registerPasswordUnderEnvironmentVariables == null) {
                this.registerPasswordUnderEnvironmentVariables = new ArrayList();
            }
            this.registerPasswordUnderEnvironmentVariables.add(registerPasswordUnderEnvironmentVariable);
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderEnvironmentVariables(Collection<? extends String> registerPasswordUnderEnvironmentVariables) {
            if (registerPasswordUnderEnvironmentVariables == null) {
                throw new NullPointerException("registerPasswordUnderEnvironmentVariables cannot be null");
            }
            if (this.registerPasswordUnderEnvironmentVariables == null) {
                this.registerPasswordUnderEnvironmentVariables = new ArrayList();
            }
            this.registerPasswordUnderEnvironmentVariables.addAll(registerPasswordUnderEnvironmentVariables);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterPasswordUnderEnvironmentVariables() {
            if (this.registerPasswordUnderEnvironmentVariables != null) {
                this.registerPasswordUnderEnvironmentVariables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B registerManagementEndpointUnderProperty(String registerManagementEndpointUnderProperty) {
            if (this.registerManagementEndpointUnderProperties == null) {
                this.registerManagementEndpointUnderProperties = new ArrayList();
            }
            this.registerManagementEndpointUnderProperties.add(registerManagementEndpointUnderProperty);
            return (B)this.self();
        }

        @Generated
        public B registerManagementEndpointUnderProperties(Collection<? extends String> registerManagementEndpointUnderProperties) {
            if (registerManagementEndpointUnderProperties == null) {
                throw new NullPointerException("registerManagementEndpointUnderProperties cannot be null");
            }
            if (this.registerManagementEndpointUnderProperties == null) {
                this.registerManagementEndpointUnderProperties = new ArrayList();
            }
            this.registerManagementEndpointUnderProperties.addAll(registerManagementEndpointUnderProperties);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterManagementEndpointUnderProperties() {
            if (this.registerManagementEndpointUnderProperties != null) {
                this.registerManagementEndpointUnderProperties.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B registerManagementEndpointUnderEnvironmentVariable(String registerManagementEndpointUnderEnvironmentVariable) {
            if (this.registerManagementEndpointUnderEnvironmentVariables == null) {
                this.registerManagementEndpointUnderEnvironmentVariables = new ArrayList();
            }
            this.registerManagementEndpointUnderEnvironmentVariables.add(registerManagementEndpointUnderEnvironmentVariable);
            return (B)this.self();
        }

        @Generated
        public B registerManagementEndpointUnderEnvironmentVariables(Collection<? extends String> registerManagementEndpointUnderEnvironmentVariables) {
            if (registerManagementEndpointUnderEnvironmentVariables == null) {
                throw new NullPointerException("registerManagementEndpointUnderEnvironmentVariables cannot be null");
            }
            if (this.registerManagementEndpointUnderEnvironmentVariables == null) {
                this.registerManagementEndpointUnderEnvironmentVariables = new ArrayList();
            }
            this.registerManagementEndpointUnderEnvironmentVariables.addAll(registerManagementEndpointUnderEnvironmentVariables);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterManagementEndpointUnderEnvironmentVariables() {
            if (this.registerManagementEndpointUnderEnvironmentVariables != null) {
                this.registerManagementEndpointUnderEnvironmentVariables.clear();
            }
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C done();

        @Generated
        public String toString() {
            return "RabbitMQDockerServiceConfigurer.RabbitMQDockerServiceConfigurerBuilder(super=" + super.toString() + ", queues=" + String.valueOf(this.queues) + ", registerUsernameUnderProperties=" + String.valueOf(this.registerUsernameUnderProperties) + ", registerUsernameUnderEnvironmentVariables=" + String.valueOf(this.registerUsernameUnderEnvironmentVariables) + ", registerPasswordUnderProperties=" + String.valueOf(this.registerPasswordUnderProperties) + ", registerPasswordUnderEnvironmentVariables=" + String.valueOf(this.registerPasswordUnderEnvironmentVariables) + ", registerManagementEndpointUnderProperties=" + String.valueOf(this.registerManagementEndpointUnderProperties) + ", registerManagementEndpointUnderEnvironmentVariables=" + String.valueOf(this.registerManagementEndpointUnderEnvironmentVariables) + ")";
        }
    }

    @Generated
    private static final class RabbitMQDockerServiceConfigurerBuilderImpl
    extends RabbitMQDockerServiceConfigurerBuilder<RabbitMQDockerServiceConfigurer, RabbitMQDockerServiceConfigurerBuilderImpl> {
        @Generated
        private RabbitMQDockerServiceConfigurerBuilderImpl() {
        }

        @Override
        @Generated
        protected RabbitMQDockerServiceConfigurerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RabbitMQDockerServiceConfigurer done() {
            return new RabbitMQDockerServiceConfigurer(this);
        }
    }
}

