/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis;

import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import pl.netroute.hussar.core.helper.CollectionHelper;
import pl.netroute.hussar.core.service.BaseDockerServiceConfig;

final class RedisDockerServiceConfig
extends BaseDockerServiceConfig {
    private final boolean enablePassword;
    @NonNull
    private final Set<String> registerUsernameUnderProperties;
    @NonNull
    private final Set<String> registerUsernameUnderEnvironmentVariables;
    @NonNull
    private final Set<String> registerPasswordUnderProperties;
    @NonNull
    private final Set<String> registerPasswordUnderEnvironmentVariables;

    protected RedisDockerServiceConfig(RedisDockerServiceConfigBuilder<?, ?> builder) {
        super(builder);
        if (this.isPasswordConfigurationValid(builder)) {
            throw new IllegalArgumentException("Redis password is disabled but password registration is required");
        }
        this.enablePassword = builder.enablePassword;
        this.registerUsernameUnderProperties = builder.registerUsernameUnderProperties;
        this.registerUsernameUnderEnvironmentVariables = builder.registerUsernameUnderEnvironmentVariables;
        this.registerPasswordUnderProperties = builder.registerPasswordUnderProperties;
        this.registerPasswordUnderEnvironmentVariables = builder.registerPasswordUnderEnvironmentVariables;
    }

    private boolean isPasswordConfigurationValid(RedisDockerServiceConfigBuilder<?, ?> builder) {
        boolean enablePassword = builder.enablePassword;
        Set<String> registerPasswordUnderProperties = builder.registerPasswordUnderProperties;
        Set<String> registerPasswordUnderEnvironmentVariables = builder.registerPasswordUnderEnvironmentVariables;
        return !enablePassword && (!CollectionHelper.isEmpty(registerPasswordUnderProperties) || !CollectionHelper.isEmpty(registerPasswordUnderEnvironmentVariables));
    }

    @Generated
    public static RedisDockerServiceConfigBuilder<?, ?> builder() {
        return new RedisDockerServiceConfigBuilderImpl();
    }

    @Generated
    public boolean isEnablePassword() {
        return this.enablePassword;
    }

    @NonNull
    @Generated
    public Set<String> getRegisterUsernameUnderProperties() {
        return this.registerUsernameUnderProperties;
    }

    @NonNull
    @Generated
    public Set<String> getRegisterUsernameUnderEnvironmentVariables() {
        return this.registerUsernameUnderEnvironmentVariables;
    }

    @NonNull
    @Generated
    public Set<String> getRegisterPasswordUnderProperties() {
        return this.registerPasswordUnderProperties;
    }

    @NonNull
    @Generated
    public Set<String> getRegisterPasswordUnderEnvironmentVariables() {
        return this.registerPasswordUnderEnvironmentVariables;
    }

    @Generated
    public String toString() {
        return "RedisDockerServiceConfig(enablePassword=" + this.isEnablePassword() + ", registerUsernameUnderProperties=" + String.valueOf(this.getRegisterUsernameUnderProperties()) + ", registerUsernameUnderEnvironmentVariables=" + String.valueOf(this.getRegisterUsernameUnderEnvironmentVariables()) + ", registerPasswordUnderProperties=" + String.valueOf(this.getRegisterPasswordUnderProperties()) + ", registerPasswordUnderEnvironmentVariables=" + String.valueOf(this.getRegisterPasswordUnderEnvironmentVariables()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisDockerServiceConfig)) {
            return false;
        }
        RedisDockerServiceConfig other = (RedisDockerServiceConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnablePassword() != other.isEnablePassword()) {
            return false;
        }
        Set<String> this$registerUsernameUnderProperties = this.getRegisterUsernameUnderProperties();
        Set<String> other$registerUsernameUnderProperties = other.getRegisterUsernameUnderProperties();
        if (this$registerUsernameUnderProperties == null ? other$registerUsernameUnderProperties != null : !((Object)this$registerUsernameUnderProperties).equals(other$registerUsernameUnderProperties)) {
            return false;
        }
        Set<String> this$registerUsernameUnderEnvironmentVariables = this.getRegisterUsernameUnderEnvironmentVariables();
        Set<String> other$registerUsernameUnderEnvironmentVariables = other.getRegisterUsernameUnderEnvironmentVariables();
        if (this$registerUsernameUnderEnvironmentVariables == null ? other$registerUsernameUnderEnvironmentVariables != null : !((Object)this$registerUsernameUnderEnvironmentVariables).equals(other$registerUsernameUnderEnvironmentVariables)) {
            return false;
        }
        Set<String> this$registerPasswordUnderProperties = this.getRegisterPasswordUnderProperties();
        Set<String> other$registerPasswordUnderProperties = other.getRegisterPasswordUnderProperties();
        if (this$registerPasswordUnderProperties == null ? other$registerPasswordUnderProperties != null : !((Object)this$registerPasswordUnderProperties).equals(other$registerPasswordUnderProperties)) {
            return false;
        }
        Set<String> this$registerPasswordUnderEnvironmentVariables = this.getRegisterPasswordUnderEnvironmentVariables();
        Set<String> other$registerPasswordUnderEnvironmentVariables = other.getRegisterPasswordUnderEnvironmentVariables();
        return !(this$registerPasswordUnderEnvironmentVariables == null ? other$registerPasswordUnderEnvironmentVariables != null : !((Object)this$registerPasswordUnderEnvironmentVariables).equals(other$registerPasswordUnderEnvironmentVariables));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedisDockerServiceConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnablePassword() ? 79 : 97);
        Set<String> $registerUsernameUnderProperties = this.getRegisterUsernameUnderProperties();
        result = result * 59 + ($registerUsernameUnderProperties == null ? 43 : ((Object)$registerUsernameUnderProperties).hashCode());
        Set<String> $registerUsernameUnderEnvironmentVariables = this.getRegisterUsernameUnderEnvironmentVariables();
        result = result * 59 + ($registerUsernameUnderEnvironmentVariables == null ? 43 : ((Object)$registerUsernameUnderEnvironmentVariables).hashCode());
        Set<String> $registerPasswordUnderProperties = this.getRegisterPasswordUnderProperties();
        result = result * 59 + ($registerPasswordUnderProperties == null ? 43 : ((Object)$registerPasswordUnderProperties).hashCode());
        Set<String> $registerPasswordUnderEnvironmentVariables = this.getRegisterPasswordUnderEnvironmentVariables();
        result = result * 59 + ($registerPasswordUnderEnvironmentVariables == null ? 43 : ((Object)$registerPasswordUnderEnvironmentVariables).hashCode());
        return result;
    }

    @Generated
    public static abstract class RedisDockerServiceConfigBuilder<C extends RedisDockerServiceConfig, B extends RedisDockerServiceConfigBuilder<C, B>>
    extends BaseDockerServiceConfig.BaseDockerServiceConfigBuilder<C, B> {
        @Generated
        private boolean enablePassword;
        @Generated
        private Set<String> registerUsernameUnderProperties;
        @Generated
        private Set<String> registerUsernameUnderEnvironmentVariables;
        @Generated
        private Set<String> registerPasswordUnderProperties;
        @Generated
        private Set<String> registerPasswordUnderEnvironmentVariables;

        @Generated
        public B enablePassword(boolean enablePassword) {
            this.enablePassword = enablePassword;
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderProperties(@NonNull Set<String> registerUsernameUnderProperties) {
            if (registerUsernameUnderProperties == null) {
                throw new NullPointerException("registerUsernameUnderProperties is marked non-null but is null");
            }
            this.registerUsernameUnderProperties = registerUsernameUnderProperties;
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderEnvironmentVariables(@NonNull Set<String> registerUsernameUnderEnvironmentVariables) {
            if (registerUsernameUnderEnvironmentVariables == null) {
                throw new NullPointerException("registerUsernameUnderEnvironmentVariables is marked non-null but is null");
            }
            this.registerUsernameUnderEnvironmentVariables = registerUsernameUnderEnvironmentVariables;
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderProperties(@NonNull Set<String> registerPasswordUnderProperties) {
            if (registerPasswordUnderProperties == null) {
                throw new NullPointerException("registerPasswordUnderProperties is marked non-null but is null");
            }
            this.registerPasswordUnderProperties = registerPasswordUnderProperties;
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderEnvironmentVariables(@NonNull Set<String> registerPasswordUnderEnvironmentVariables) {
            if (registerPasswordUnderEnvironmentVariables == null) {
                throw new NullPointerException("registerPasswordUnderEnvironmentVariables is marked non-null but is null");
            }
            this.registerPasswordUnderEnvironmentVariables = registerPasswordUnderEnvironmentVariables;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RedisDockerServiceConfig.RedisDockerServiceConfigBuilder(super=" + super.toString() + ", enablePassword=" + this.enablePassword + ", registerUsernameUnderProperties=" + String.valueOf(this.registerUsernameUnderProperties) + ", registerUsernameUnderEnvironmentVariables=" + String.valueOf(this.registerUsernameUnderEnvironmentVariables) + ", registerPasswordUnderProperties=" + String.valueOf(this.registerPasswordUnderProperties) + ", registerPasswordUnderEnvironmentVariables=" + String.valueOf(this.registerPasswordUnderEnvironmentVariables) + ")";
        }
    }

    @Generated
    private static final class RedisDockerServiceConfigBuilderImpl
    extends RedisDockerServiceConfigBuilder<RedisDockerServiceConfig, RedisDockerServiceConfigBuilderImpl> {
        @Generated
        private RedisDockerServiceConfigBuilderImpl() {
        }

        @Override
        @Generated
        protected RedisDockerServiceConfigBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RedisDockerServiceConfig build() {
            return new RedisDockerServiceConfig(this);
        }
    }
}

