/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis;

import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import pl.netroute.hussar.service.nosql.redis.api.RedisCredentials;

class RedisPasswordConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisPasswordConfigurer.class);
    private static final String CONFIGURE_PASSWORD_COMMAND = "redis-cli -h %s -p %d config set requirepass %s";
    private static final String COMMAND_SPLITTER = " ";

    void configure(@NonNull RedisCredentials credentials, @NonNull GenericContainer<?> container) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        container.getExposedPorts().forEach(port -> this.configureInstancePassword((int)port, credentials, container));
    }

    private void configureInstancePassword(int port, RedisCredentials credentials, GenericContainer<?> container) {
        log.info("Configuring Redis[{}] credentials - {}", (Object)port, (Object)credentials);
        String host = container.getHost();
        String password = credentials.password();
        String[] command = CONFIGURE_PASSWORD_COMMAND.formatted(host, port, password).split(COMMAND_SPLITTER);
        try {
            Container.ExecResult result = container.execInContainer(command);
            if (result.getExitCode() != 0) {
                String errorMessage = "Failed to configure Redis[%d] credentials - %s".formatted(port, result.getStderr());
                throw new IllegalStateException(errorMessage);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not configure Redis credentials", ex);
        }
    }

    @Generated
    public RedisPasswordConfigurer() {
    }
}

