/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis.api;

import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import pl.netroute.hussar.core.api.InternalUseOnly;
import pl.netroute.hussar.core.docker.DockerCommandLineRunner;

@InternalUseOnly
class RedisClusterAnnounceIpConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisClusterAnnounceIpConfigurer.class);
    private static final String CONFIGURE_CLUSTER_ANNOUNCE_IP_COMMAND = "redis-cli -h %s -p %d CONFIG SET cluster-announce-ip %s";
    private final DockerCommandLineRunner commandLineRunner;

    void configure(@NonNull String clusterAnnounceIp, @NonNull FixedHostPortGenericContainer<?> container) {
        if (clusterAnnounceIp == null) {
            throw new NullPointerException("clusterAnnounceIp is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        String host = container.getHost();
        container.getBoundPortNumbers().forEach(port -> this.configureInstanceClusterAnnounceIp(host, (int)port, clusterAnnounceIp, (GenericContainer<?>)container));
    }

    private void configureInstanceClusterAnnounceIp(String host, int port, String clusterAnnounceIp, GenericContainer<?> container) {
        log.info("Configuring Redis[{}:{}] cluster announce IP to {}", new Object[]{host, port, clusterAnnounceIp});
        String command = CONFIGURE_CLUSTER_ANNOUNCE_IP_COMMAND.formatted(host, port, clusterAnnounceIp);
        this.commandLineRunner.run(command, container);
    }

    @Generated
    RedisClusterAnnounceIpConfigurer(DockerCommandLineRunner commandLineRunner) {
        this.commandLineRunner = commandLineRunner;
    }
}

