/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis.api;

import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import pl.netroute.hussar.core.api.InternalUseOnly;
import pl.netroute.hussar.core.docker.DockerCommandLineRunner;

@InternalUseOnly
class RedisClusterNoProtectionConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisClusterNoProtectionConfigurer.class);
    private static final String DISABLE_PROTECTION_MODE_COMMAND = "redis-cli -h %s -p %d CONFIG SET protection-mode no";
    private final DockerCommandLineRunner commandLineRunner;

    void configure(@NonNull GenericContainer<?> container) {
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        String host = container.getHost();
        container.getBoundPortNumbers().forEach(port -> this.disableClusterInstanceProtectionMode(host, (int)port, container));
    }

    private void disableClusterInstanceProtectionMode(String host, int port, GenericContainer<?> container) {
        log.info("Disabling Redis[{}:{}] protection mode", (Object)host, (Object)port);
        String command = DISABLE_PROTECTION_MODE_COMMAND.formatted(host, port);
        this.commandLineRunner.run(command, container);
    }

    @Generated
    RedisClusterNoProtectionConfigurer(DockerCommandLineRunner commandLineRunner) {
        this.commandLineRunner = commandLineRunner;
    }
}

