/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis.api;

import lombok.Generated;
import lombok.NonNull;
import org.testcontainers.containers.GenericContainer;
import pl.netroute.hussar.core.configuration.api.ConfigurationRegistry;
import pl.netroute.hussar.core.network.api.NetworkConfigurer;
import pl.netroute.hussar.core.service.ServiceStartupContext;
import pl.netroute.hussar.core.service.api.BaseDockerService;
import pl.netroute.hussar.core.service.api.BaseDockerServiceConfig;
import pl.netroute.hussar.core.service.registerer.EndpointRegisterer;
import pl.netroute.hussar.service.nosql.redis.api.RedisCredentials;
import pl.netroute.hussar.service.nosql.redis.api.RedisCredentialsRegisterer;
import pl.netroute.hussar.service.nosql.redis.api.RedisDockerServiceConfig;
import pl.netroute.hussar.service.nosql.redis.api.RedisPasswordConfigurer;

public class RedisDockerService
extends BaseDockerService<RedisDockerServiceConfig> {
    @NonNull
    private final RedisCredentials credentials;
    @NonNull
    private final RedisCredentialsRegisterer credentialsRegisterer;
    @NonNull
    private final RedisPasswordConfigurer passwordConfigurer;

    RedisDockerService(@NonNull GenericContainer<?> container, @NonNull RedisDockerServiceConfig config, @NonNull ConfigurationRegistry configurationRegistry, @NonNull EndpointRegisterer endpointRegisterer, @NonNull NetworkConfigurer networkConfigurer, @NonNull RedisCredentialsRegisterer credentialsRegisterer, @NonNull RedisPasswordConfigurer passwordConfigurer) {
        super(container, (BaseDockerServiceConfig)config, configurationRegistry, endpointRegisterer, networkConfigurer);
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (configurationRegistry == null) {
            throw new NullPointerException("configurationRegistry is marked non-null but is null");
        }
        if (endpointRegisterer == null) {
            throw new NullPointerException("endpointRegisterer is marked non-null but is null");
        }
        if (networkConfigurer == null) {
            throw new NullPointerException("networkConfigurer is marked non-null but is null");
        }
        if (credentialsRegisterer == null) {
            throw new NullPointerException("credentialsRegisterer is marked non-null but is null");
        }
        if (passwordConfigurer == null) {
            throw new NullPointerException("passwordConfigurer is marked non-null but is null");
        }
        this.credentials = this.isPasswordEnabled() ? new RedisCredentials("default", "test") : RedisCredentials.passwordLess("default");
        this.credentialsRegisterer = credentialsRegisterer;
        this.passwordConfigurer = passwordConfigurer;
    }

    protected void configureContainer(GenericContainer<?> container) {
        super.configureContainer(container);
        container.withExposedPorts(new Integer[]{6379});
    }

    protected void doAfterServiceStartup(ServiceStartupContext context) {
        super.doAfterServiceStartup(context);
        if (this.isPasswordEnabled()) {
            this.passwordConfigurer.configure(this.credentials, this.container);
        }
        this.registerCredentialsUnderProperties();
        this.registerCredentialsUnderEnvironmentVariables();
    }

    private boolean isPasswordEnabled() {
        return ((RedisDockerServiceConfig)this.config).isEnablePassword();
    }

    private void registerCredentialsUnderProperties() {
        ((RedisDockerServiceConfig)this.config).getRegisterUsernameUnderProperties().forEach(usernameProperty -> this.credentialsRegisterer.registerUsernameUnderProperty(this.credentials, (String)usernameProperty));
        ((RedisDockerServiceConfig)this.config).getRegisterPasswordUnderProperties().forEach(passwordProperty -> this.credentialsRegisterer.registerPasswordUnderProperty(this.credentials, (String)passwordProperty));
    }

    private void registerCredentialsUnderEnvironmentVariables() {
        ((RedisDockerServiceConfig)this.config).getRegisterUsernameUnderEnvironmentVariables().forEach(usernameEnvVariable -> this.credentialsRegisterer.registerUsernameUnderEnvironmentVariable(this.credentials, (String)usernameEnvVariable));
        ((RedisDockerServiceConfig)this.config).getRegisterPasswordUnderEnvironmentVariables().forEach(passwordEnvVariable -> this.credentialsRegisterer.registerPasswordUnderEnvironmentVariable(this.credentials, (String)passwordEnvVariable));
    }

    @NonNull
    @Generated
    public RedisCredentials getCredentials() {
        return this.credentials;
    }
}

