/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis.api;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import pl.netroute.hussar.core.api.InternalUseOnly;
import pl.netroute.hussar.core.docker.DockerCommandLineRunner;
import pl.netroute.hussar.service.nosql.redis.api.RedisCredentials;

@InternalUseOnly
class RedisPasswordConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisPasswordConfigurer.class);
    private static final String CONFIGURE_PASSWORD_COMMAND = "redis-cli -h %s -p %d CONFIG SET requirepass %s";
    private final DockerCommandLineRunner commandLineRunner;

    void configure(@NonNull RedisCredentials credentials, @NonNull GenericContainer<?> container) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        String host = container.getHost();
        this.getPorts(container).forEach(port -> this.configureInstancePassword(host, (int)port, credentials, container));
    }

    private void configureInstancePassword(String host, int port, RedisCredentials credentials, GenericContainer<?> container) {
        log.info("Configuring Redis[{}:{}] security credentials - {}", new Object[]{host, port, credentials});
        String password = credentials.password();
        String command = CONFIGURE_PASSWORD_COMMAND.formatted(host, port, password);
        this.commandLineRunner.run(command, container);
    }

    private List<Integer> getPorts(GenericContainer<?> container) {
        GenericContainer<?> genericContainer = container;
        Objects.requireNonNull(genericContainer);
        GenericContainer<?> genericContainer2 = genericContainer;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FixedHostPortGenericContainer.class}, genericContainer2, n)) {
            case 0 -> {
                FixedHostPortGenericContainer fixedContainer = (FixedHostPortGenericContainer)genericContainer2;
                yield fixedContainer.getBoundPortNumbers();
            }
            default -> container.getExposedPorts();
        };
    }

    @Generated
    RedisPasswordConfigurer(DockerCommandLineRunner commandLineRunner) {
        this.commandLineRunner = commandLineRunner;
    }
}

