/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis.api;

import java.util.List;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import pl.netroute.hussar.core.configuration.api.ConfigurationRegistry;
import pl.netroute.hussar.core.docker.DockerHostResolver;
import pl.netroute.hussar.core.docker.api.DockerNetwork;
import pl.netroute.hussar.core.network.api.NetworkConfigurer;
import pl.netroute.hussar.core.service.ServiceStartupContext;
import pl.netroute.hussar.core.service.api.BaseDockerService;
import pl.netroute.hussar.core.service.api.BaseDockerServiceConfig;
import pl.netroute.hussar.core.service.registerer.EndpointRegisterer;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterAnnounceIpConfigurer;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterDockerServiceConfig;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterNoProtectionConfigurer;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterReplicationPasswordConfigurer;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterWaitStrategy;
import pl.netroute.hussar.service.nosql.redis.api.RedisCredentials;
import pl.netroute.hussar.service.nosql.redis.api.RedisCredentialsRegisterer;
import pl.netroute.hussar.service.nosql.redis.api.RedisPasswordConfigurer;

public class RedisClusterDockerService
extends BaseDockerService<RedisClusterDockerServiceConfig> {
    @NonNull
    private final RedisCredentials credentials;
    @NonNull
    private final RedisCredentialsRegisterer credentialsRegisterer;
    @NonNull
    private final RedisPasswordConfigurer passwordConfigurer;
    @NonNull
    private final RedisClusterReplicationPasswordConfigurer clusterReplicationPasswordConfigurer;
    @NonNull
    private final RedisClusterAnnounceIpConfigurer redisClusterAnnounceIpConfigurer;
    @NonNull
    private final RedisClusterNoProtectionConfigurer redisClusterNoProtectionConfigurer;
    @NonNull
    private final RedisClusterWaitStrategy clusterWaitStrategy;
    @NonNull
    private final DockerHostResolver dockerHostResolver;
    @NonNull
    private final List<Integer> clusterNodesPorts;

    RedisClusterDockerService(@NonNull FixedHostPortGenericContainer<?> container, @NonNull DockerNetwork dockerNetwork, @NonNull RedisClusterDockerServiceConfig config, @NonNull ConfigurationRegistry configurationRegistry, @NonNull EndpointRegisterer endpointRegisterer, @NonNull NetworkConfigurer networkConfigurer, @NonNull RedisCredentialsRegisterer credentialsRegisterer, @NonNull RedisPasswordConfigurer passwordConfigurer, @NonNull RedisClusterReplicationPasswordConfigurer clusterReplicationPasswordConfigurer, @NonNull RedisClusterAnnounceIpConfigurer clusterAnnounceIpConfigurer, @NonNull RedisClusterNoProtectionConfigurer redisClusterNoProtectionConfigurer, @NonNull RedisClusterWaitStrategy clusterWaitStrategy, @NonNull DockerHostResolver dockerHostResolver) {
        super(container, dockerNetwork, (BaseDockerServiceConfig)config, configurationRegistry, endpointRegisterer, networkConfigurer);
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        if (dockerNetwork == null) {
            throw new NullPointerException("dockerNetwork is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (configurationRegistry == null) {
            throw new NullPointerException("configurationRegistry is marked non-null but is null");
        }
        if (endpointRegisterer == null) {
            throw new NullPointerException("endpointRegisterer is marked non-null but is null");
        }
        if (networkConfigurer == null) {
            throw new NullPointerException("networkConfigurer is marked non-null but is null");
        }
        if (credentialsRegisterer == null) {
            throw new NullPointerException("credentialsRegisterer is marked non-null but is null");
        }
        if (passwordConfigurer == null) {
            throw new NullPointerException("passwordConfigurer is marked non-null but is null");
        }
        if (clusterReplicationPasswordConfigurer == null) {
            throw new NullPointerException("clusterReplicationPasswordConfigurer is marked non-null but is null");
        }
        if (clusterAnnounceIpConfigurer == null) {
            throw new NullPointerException("clusterAnnounceIpConfigurer is marked non-null but is null");
        }
        if (redisClusterNoProtectionConfigurer == null) {
            throw new NullPointerException("redisClusterNoProtectionConfigurer is marked non-null but is null");
        }
        if (clusterWaitStrategy == null) {
            throw new NullPointerException("clusterWaitStrategy is marked non-null but is null");
        }
        if (dockerHostResolver == null) {
            throw new NullPointerException("dockerHostResolver is marked non-null but is null");
        }
        this.credentials = this.isClusterPasswordEnabled() ? new RedisCredentials("default", "test") : RedisCredentials.passwordLess("default");
        this.credentialsRegisterer = credentialsRegisterer;
        this.passwordConfigurer = passwordConfigurer;
        this.clusterReplicationPasswordConfigurer = clusterReplicationPasswordConfigurer;
        this.redisClusterAnnounceIpConfigurer = clusterAnnounceIpConfigurer;
        this.redisClusterNoProtectionConfigurer = redisClusterNoProtectionConfigurer;
        this.clusterWaitStrategy = clusterWaitStrategy;
        this.dockerHostResolver = dockerHostResolver;
        this.clusterNodesPorts = IntStream.range(0, 6).map(node -> 7000 + node).boxed().toList();
    }

    protected List<Integer> getInternalPorts() {
        return this.clusterNodesPorts;
    }

    protected void configureContainer(GenericContainer<?> container) {
        super.configureContainer(container);
        FixedHostPortGenericContainer fixedHostPortContainer = (FixedHostPortGenericContainer)container;
        if (!this.dockerHostResolver.isLocalHost()) {
            this.configureClusterDockerHost(fixedHostPortContainer);
        }
    }

    protected void configureExposedPorts(GenericContainer<?> container) {
        FixedHostPortGenericContainer fixedHostPortContainer = (FixedHostPortGenericContainer)container;
        this.getInternalPorts().forEach(port -> fixedHostPortContainer.withFixedExposedPort(port.intValue(), port.intValue()));
    }

    protected void configureEnvVariables(GenericContainer<?> container) {
        super.configureEnvVariables(container);
        FixedHostPortGenericContainer fixedHostPortContainer = (FixedHostPortGenericContainer)container;
        fixedHostPortContainer.withEnv("IP", "0.0.0.0");
        fixedHostPortContainer.withEnv("MASTERS", "3");
        fixedHostPortContainer.withEnv("SLAVES_PER_MASTER", "1");
    }

    protected void doAfterServiceStartup(ServiceStartupContext context) {
        super.doAfterServiceStartup(context);
        FixedHostPortGenericContainer fixedHostPortContainer = (FixedHostPortGenericContainer)this.container;
        if (!this.dockerHostResolver.isLocalHost()) {
            this.configureClusterAvailability(fixedHostPortContainer);
        }
        if (this.isClusterPasswordEnabled()) {
            this.configureClusterPassword(fixedHostPortContainer, this.credentials);
        }
        this.disableProtectionMode(fixedHostPortContainer);
        this.registerCredentialsUnderProperties();
        this.registerCredentialsUnderEnvironmentVariables();
    }

    protected void configureWaitStrategy(GenericContainer<?> container) {
        container.waitingFor((WaitStrategy)this.clusterWaitStrategy);
    }

    private boolean isClusterPasswordEnabled() {
        return ((RedisClusterDockerServiceConfig)this.config).isEnablePassword();
    }

    private void configureClusterDockerHost(FixedHostPortGenericContainer<?> container) {
        String dockerHost = this.dockerHostResolver.getHost();
        container.withExtraHost(dockerHost, "127.0.0.1");
    }

    private void configureClusterAvailability(FixedHostPortGenericContainer<?> container) {
        String dockerHost = this.dockerHostResolver.getHost();
        this.redisClusterAnnounceIpConfigurer.configure(dockerHost, container);
    }

    private void configureClusterPassword(FixedHostPortGenericContainer<?> container, RedisCredentials credentials) {
        this.clusterReplicationPasswordConfigurer.configure(credentials, container);
        this.passwordConfigurer.configure(credentials, (GenericContainer<?>)container);
    }

    private void disableProtectionMode(FixedHostPortGenericContainer<?> container) {
        this.redisClusterNoProtectionConfigurer.configure(container);
    }

    private void registerCredentialsUnderProperties() {
        ((RedisClusterDockerServiceConfig)this.config).getRegisterUsernameUnderProperties().forEach(usernameProperty -> this.credentialsRegisterer.registerUsernameUnderProperty(this.credentials, (String)usernameProperty));
        ((RedisClusterDockerServiceConfig)this.config).getRegisterPasswordUnderProperties().forEach(passwordProperty -> this.credentialsRegisterer.registerPasswordUnderProperty(this.credentials, (String)passwordProperty));
    }

    private void registerCredentialsUnderEnvironmentVariables() {
        ((RedisClusterDockerServiceConfig)this.config).getRegisterUsernameUnderEnvironmentVariables().forEach(usernameEnvVariable -> this.credentialsRegisterer.registerUsernameUnderEnvironmentVariable(this.credentials, (String)usernameEnvVariable));
        ((RedisClusterDockerServiceConfig)this.config).getRegisterPasswordUnderEnvironmentVariables().forEach(passwordEnvVariable -> this.credentialsRegisterer.registerPasswordUnderEnvironmentVariable(this.credentials, (String)passwordEnvVariable));
    }

    @NonNull
    @Generated
    public RedisCredentials getCredentials() {
        return this.credentials;
    }
}

