/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis.api;

import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import pl.netroute.hussar.core.api.InternalUseOnly;
import pl.netroute.hussar.core.docker.DockerCommandLineRunner;
import pl.netroute.hussar.service.nosql.redis.api.RedisCredentials;

@InternalUseOnly
class RedisClusterReplicationPasswordConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisClusterReplicationPasswordConfigurer.class);
    private static final String CONFIGURE_PASSWORD_REPLICATION_COMMAND = "redis-cli -h %s -p %d CONFIG SET masterauth %s";
    private final DockerCommandLineRunner commandLineRunner;

    void configure(@NonNull RedisCredentials credentials, @NonNull FixedHostPortGenericContainer<?> container) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        String host = container.getHost();
        container.getBoundPortNumbers().forEach(port -> this.configureInstanceReplicationPassword(host, (int)port, credentials, (GenericContainer<?>)container));
    }

    private void configureInstanceReplicationPassword(String host, int port, RedisCredentials credentials, GenericContainer<?> container) {
        log.info("Configuring Redis[{}:{}] replication password to {}", new Object[]{host, port, credentials});
        String password = credentials.password();
        String command = CONFIGURE_PASSWORD_REPLICATION_COMMAND.formatted(host, port, password);
        this.commandLineRunner.run(command, container);
    }

    @Generated
    RedisClusterReplicationPasswordConfigurer(DockerCommandLineRunner commandLineRunner) {
        this.commandLineRunner = commandLineRunner;
    }
}

