/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.utility.DockerImageName;
import pl.netroute.hussar.core.configuration.api.ConfigurationRegistry;
import pl.netroute.hussar.core.configuration.api.DefaultConfigurationRegistry;
import pl.netroute.hussar.core.docker.DockerCommandLineRunner;
import pl.netroute.hussar.core.docker.DockerHostResolver;
import pl.netroute.hussar.core.docker.DockerImageResolver;
import pl.netroute.hussar.core.docker.DockerRegistryResolver;
import pl.netroute.hussar.core.docker.api.DockerNetwork;
import pl.netroute.hussar.core.docker.api.DockerRegistry;
import pl.netroute.hussar.core.network.api.NetworkConfigurer;
import pl.netroute.hussar.core.service.ServiceConfigureContext;
import pl.netroute.hussar.core.service.api.BaseDockerServiceConfigurer;
import pl.netroute.hussar.core.service.registerer.EndpointRegisterer;
import pl.netroute.hussar.core.service.resolver.ServiceNameResolver;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterAnnounceIpConfigurer;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterDockerService;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterDockerServiceConfig;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterNoProtectionConfigurer;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterReplicationPasswordConfigurer;
import pl.netroute.hussar.service.nosql.redis.api.RedisClusterWaitStrategy;
import pl.netroute.hussar.service.nosql.redis.api.RedisCredentialsRegisterer;
import pl.netroute.hussar.service.nosql.redis.api.RedisPasswordConfigurer;

public class RedisClusterDockerServiceConfigurer
extends BaseDockerServiceConfigurer<RedisClusterDockerService> {
    private static final String DOCKER_IMAGE = "grokzen/redis-cluster";
    private static final String SERVICE = "redis_cluster_service";
    protected boolean enablePassword;
    protected final Set<String> registerUsernameUnderProperties;
    protected final Set<String> registerUsernameUnderEnvironmentVariables;
    protected final Set<String> registerPasswordUnderProperties;
    protected final Set<String> registerPasswordUnderEnvironmentVariables;

    public RedisClusterDockerService configure(@NonNull ServiceConfigureContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        DockerRegistry resolvedDockerRegistry = DockerRegistryResolver.resolve((DockerRegistry)this.dockerRegistry, (ServiceConfigureContext)context);
        DockerNetwork dockerNetwork = context.dockerNetwork();
        NetworkConfigurer networkConfigurer = context.networkConfigurer();
        DockerImageName dockerImage = DockerImageResolver.resolve((DockerRegistry)resolvedDockerRegistry, (String)DOCKER_IMAGE, (String)this.dockerImageVersion);
        DockerCommandLineRunner dockerCommandLineRunner = new DockerCommandLineRunner();
        RedisClusterDockerServiceConfig config = this.createConfig(dockerImage);
        FixedHostPortGenericContainer container = new FixedHostPortGenericContainer(dockerImage.asCanonicalNameString());
        DefaultConfigurationRegistry configurationRegistry = new DefaultConfigurationRegistry();
        EndpointRegisterer endpointRegisterer = new EndpointRegisterer((ConfigurationRegistry)configurationRegistry);
        RedisCredentialsRegisterer credentialsRegisterer = new RedisCredentialsRegisterer((ConfigurationRegistry)configurationRegistry);
        RedisPasswordConfigurer passwordConfigurer = new RedisPasswordConfigurer(dockerCommandLineRunner);
        RedisClusterReplicationPasswordConfigurer clusterReplicationPasswordConfigurer = new RedisClusterReplicationPasswordConfigurer(dockerCommandLineRunner);
        RedisClusterAnnounceIpConfigurer clusterAnnounceIpConfigurer = new RedisClusterAnnounceIpConfigurer(dockerCommandLineRunner);
        RedisClusterNoProtectionConfigurer clusterNoProtectionConfigurer = new RedisClusterNoProtectionConfigurer(dockerCommandLineRunner);
        RedisClusterWaitStrategy clusterWaitStrategy = new RedisClusterWaitStrategy(dockerCommandLineRunner);
        DockerHostResolver dockerHostResolver = new DockerHostResolver();
        return new RedisClusterDockerService(container, dockerNetwork, config, (ConfigurationRegistry)configurationRegistry, endpointRegisterer, networkConfigurer, credentialsRegisterer, passwordConfigurer, clusterReplicationPasswordConfigurer, clusterAnnounceIpConfigurer, clusterNoProtectionConfigurer, clusterWaitStrategy, dockerHostResolver);
    }

    private RedisClusterDockerServiceConfig createConfig(DockerImageName dockerImage) {
        String resolvedName = ServiceNameResolver.resolve((String)SERVICE, (String)this.name);
        return ((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)((Object)((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)((Object)((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)((Object)((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)((Object)((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)((RedisClusterDockerServiceConfig.RedisClusterDockerServiceConfigBuilder)RedisClusterDockerServiceConfig.builder().name(resolvedName)).dockerImage(dockerImage.asCanonicalNameString())).startupTimeout(this.startupTimeout)).scheme("")).enablePassword(this.enablePassword))).registerUsernameUnderProperties(this.registerUsernameUnderProperties))).registerUsernameUnderEnvironmentVariables(this.registerUsernameUnderEnvironmentVariables))).registerPasswordUnderProperties(this.registerPasswordUnderProperties))).registerPasswordUnderEnvironmentVariables(this.registerPasswordUnderEnvironmentVariables).registerEndpointUnderProperties(this.registerEndpointUnderProperties)).registerEndpointUnderEnvironmentVariables(this.registerEndpointUnderEnvironmentVariables)).build();
    }

    @Generated
    private static boolean $default$enablePassword() {
        return false;
    }

    @Generated
    protected RedisClusterDockerServiceConfigurer(RedisClusterDockerServiceConfigurerBuilder<?, ?> b) {
        super(b);
        Set<Object> registerPasswordUnderEnvironmentVariables;
        Set<Object> registerPasswordUnderProperties;
        Set<Object> registerUsernameUnderEnvironmentVariables;
        Set<Object> registerUsernameUnderProperties;
        this.enablePassword = b.enablePassword$set ? b.enablePassword$value : RedisClusterDockerServiceConfigurer.$default$enablePassword();
        switch (b.registerUsernameUnderProperties == null ? 0 : b.registerUsernameUnderProperties.size()) {
            case 0: {
                registerUsernameUnderProperties = Collections.emptySet();
                break;
            }
            case 1: {
                registerUsernameUnderProperties = Collections.singleton(b.registerUsernameUnderProperties.get(0));
                break;
            }
            default: {
                registerUsernameUnderProperties = new LinkedHashSet(b.registerUsernameUnderProperties.size() < 0x40000000 ? 1 + b.registerUsernameUnderProperties.size() + (b.registerUsernameUnderProperties.size() - 3) / 3 : Integer.MAX_VALUE);
                registerUsernameUnderProperties.addAll(b.registerUsernameUnderProperties);
                registerUsernameUnderProperties = Collections.unmodifiableSet(registerUsernameUnderProperties);
            }
        }
        this.registerUsernameUnderProperties = registerUsernameUnderProperties;
        switch (b.registerUsernameUnderEnvironmentVariables == null ? 0 : b.registerUsernameUnderEnvironmentVariables.size()) {
            case 0: {
                registerUsernameUnderEnvironmentVariables = Collections.emptySet();
                break;
            }
            case 1: {
                registerUsernameUnderEnvironmentVariables = Collections.singleton(b.registerUsernameUnderEnvironmentVariables.get(0));
                break;
            }
            default: {
                registerUsernameUnderEnvironmentVariables = new LinkedHashSet(b.registerUsernameUnderEnvironmentVariables.size() < 0x40000000 ? 1 + b.registerUsernameUnderEnvironmentVariables.size() + (b.registerUsernameUnderEnvironmentVariables.size() - 3) / 3 : Integer.MAX_VALUE);
                registerUsernameUnderEnvironmentVariables.addAll(b.registerUsernameUnderEnvironmentVariables);
                registerUsernameUnderEnvironmentVariables = Collections.unmodifiableSet(registerUsernameUnderEnvironmentVariables);
            }
        }
        this.registerUsernameUnderEnvironmentVariables = registerUsernameUnderEnvironmentVariables;
        switch (b.registerPasswordUnderProperties == null ? 0 : b.registerPasswordUnderProperties.size()) {
            case 0: {
                registerPasswordUnderProperties = Collections.emptySet();
                break;
            }
            case 1: {
                registerPasswordUnderProperties = Collections.singleton(b.registerPasswordUnderProperties.get(0));
                break;
            }
            default: {
                registerPasswordUnderProperties = new LinkedHashSet(b.registerPasswordUnderProperties.size() < 0x40000000 ? 1 + b.registerPasswordUnderProperties.size() + (b.registerPasswordUnderProperties.size() - 3) / 3 : Integer.MAX_VALUE);
                registerPasswordUnderProperties.addAll(b.registerPasswordUnderProperties);
                registerPasswordUnderProperties = Collections.unmodifiableSet(registerPasswordUnderProperties);
            }
        }
        this.registerPasswordUnderProperties = registerPasswordUnderProperties;
        switch (b.registerPasswordUnderEnvironmentVariables == null ? 0 : b.registerPasswordUnderEnvironmentVariables.size()) {
            case 0: {
                registerPasswordUnderEnvironmentVariables = Collections.emptySet();
                break;
            }
            case 1: {
                registerPasswordUnderEnvironmentVariables = Collections.singleton(b.registerPasswordUnderEnvironmentVariables.get(0));
                break;
            }
            default: {
                registerPasswordUnderEnvironmentVariables = new LinkedHashSet(b.registerPasswordUnderEnvironmentVariables.size() < 0x40000000 ? 1 + b.registerPasswordUnderEnvironmentVariables.size() + (b.registerPasswordUnderEnvironmentVariables.size() - 3) / 3 : Integer.MAX_VALUE);
                registerPasswordUnderEnvironmentVariables.addAll(b.registerPasswordUnderEnvironmentVariables);
                registerPasswordUnderEnvironmentVariables = Collections.unmodifiableSet(registerPasswordUnderEnvironmentVariables);
            }
        }
        this.registerPasswordUnderEnvironmentVariables = registerPasswordUnderEnvironmentVariables;
    }

    @Generated
    public static RedisClusterDockerServiceConfigurerBuilder<?, ?> newInstance() {
        return new RedisClusterDockerServiceConfigurerBuilderImpl();
    }

    @Generated
    public static abstract class RedisClusterDockerServiceConfigurerBuilder<C extends RedisClusterDockerServiceConfigurer, B extends RedisClusterDockerServiceConfigurerBuilder<C, B>>
    extends BaseDockerServiceConfigurer.BaseDockerServiceConfigurerBuilder<RedisClusterDockerService, C, B> {
        @Generated
        private boolean enablePassword$set;
        @Generated
        private boolean enablePassword$value;
        @Generated
        private ArrayList<String> registerUsernameUnderProperties;
        @Generated
        private ArrayList<String> registerUsernameUnderEnvironmentVariables;
        @Generated
        private ArrayList<String> registerPasswordUnderProperties;
        @Generated
        private ArrayList<String> registerPasswordUnderEnvironmentVariables;

        @Generated
        public B enablePassword(boolean enablePassword) {
            this.enablePassword$value = enablePassword;
            this.enablePassword$set = true;
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderProperty(String registerUsernameUnderProperty) {
            if (this.registerUsernameUnderProperties == null) {
                this.registerUsernameUnderProperties = new ArrayList();
            }
            this.registerUsernameUnderProperties.add(registerUsernameUnderProperty);
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderProperties(Collection<? extends String> registerUsernameUnderProperties) {
            if (registerUsernameUnderProperties == null) {
                throw new NullPointerException("registerUsernameUnderProperties cannot be null");
            }
            if (this.registerUsernameUnderProperties == null) {
                this.registerUsernameUnderProperties = new ArrayList();
            }
            this.registerUsernameUnderProperties.addAll(registerUsernameUnderProperties);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterUsernameUnderProperties() {
            if (this.registerUsernameUnderProperties != null) {
                this.registerUsernameUnderProperties.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderEnvironmentVariable(String registerUsernameUnderEnvironmentVariable) {
            if (this.registerUsernameUnderEnvironmentVariables == null) {
                this.registerUsernameUnderEnvironmentVariables = new ArrayList();
            }
            this.registerUsernameUnderEnvironmentVariables.add(registerUsernameUnderEnvironmentVariable);
            return (B)this.self();
        }

        @Generated
        public B registerUsernameUnderEnvironmentVariables(Collection<? extends String> registerUsernameUnderEnvironmentVariables) {
            if (registerUsernameUnderEnvironmentVariables == null) {
                throw new NullPointerException("registerUsernameUnderEnvironmentVariables cannot be null");
            }
            if (this.registerUsernameUnderEnvironmentVariables == null) {
                this.registerUsernameUnderEnvironmentVariables = new ArrayList();
            }
            this.registerUsernameUnderEnvironmentVariables.addAll(registerUsernameUnderEnvironmentVariables);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterUsernameUnderEnvironmentVariables() {
            if (this.registerUsernameUnderEnvironmentVariables != null) {
                this.registerUsernameUnderEnvironmentVariables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderProperty(String registerPasswordUnderProperty) {
            if (this.registerPasswordUnderProperties == null) {
                this.registerPasswordUnderProperties = new ArrayList();
            }
            this.registerPasswordUnderProperties.add(registerPasswordUnderProperty);
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderProperties(Collection<? extends String> registerPasswordUnderProperties) {
            if (registerPasswordUnderProperties == null) {
                throw new NullPointerException("registerPasswordUnderProperties cannot be null");
            }
            if (this.registerPasswordUnderProperties == null) {
                this.registerPasswordUnderProperties = new ArrayList();
            }
            this.registerPasswordUnderProperties.addAll(registerPasswordUnderProperties);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterPasswordUnderProperties() {
            if (this.registerPasswordUnderProperties != null) {
                this.registerPasswordUnderProperties.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderEnvironmentVariable(String registerPasswordUnderEnvironmentVariable) {
            if (this.registerPasswordUnderEnvironmentVariables == null) {
                this.registerPasswordUnderEnvironmentVariables = new ArrayList();
            }
            this.registerPasswordUnderEnvironmentVariables.add(registerPasswordUnderEnvironmentVariable);
            return (B)this.self();
        }

        @Generated
        public B registerPasswordUnderEnvironmentVariables(Collection<? extends String> registerPasswordUnderEnvironmentVariables) {
            if (registerPasswordUnderEnvironmentVariables == null) {
                throw new NullPointerException("registerPasswordUnderEnvironmentVariables cannot be null");
            }
            if (this.registerPasswordUnderEnvironmentVariables == null) {
                this.registerPasswordUnderEnvironmentVariables = new ArrayList();
            }
            this.registerPasswordUnderEnvironmentVariables.addAll(registerPasswordUnderEnvironmentVariables);
            return (B)this.self();
        }

        @Generated
        public B clearRegisterPasswordUnderEnvironmentVariables() {
            if (this.registerPasswordUnderEnvironmentVariables != null) {
                this.registerPasswordUnderEnvironmentVariables.clear();
            }
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C done();

        @Generated
        public String toString() {
            return "RedisClusterDockerServiceConfigurer.RedisClusterDockerServiceConfigurerBuilder(super=" + super.toString() + ", enablePassword$value=" + this.enablePassword$value + ", registerUsernameUnderProperties=" + String.valueOf(this.registerUsernameUnderProperties) + ", registerUsernameUnderEnvironmentVariables=" + String.valueOf(this.registerUsernameUnderEnvironmentVariables) + ", registerPasswordUnderProperties=" + String.valueOf(this.registerPasswordUnderProperties) + ", registerPasswordUnderEnvironmentVariables=" + String.valueOf(this.registerPasswordUnderEnvironmentVariables) + ")";
        }
    }

    @Generated
    private static final class RedisClusterDockerServiceConfigurerBuilderImpl
    extends RedisClusterDockerServiceConfigurerBuilder<RedisClusterDockerServiceConfigurer, RedisClusterDockerServiceConfigurerBuilderImpl> {
        @Generated
        private RedisClusterDockerServiceConfigurerBuilderImpl() {
        }

        @Override
        @Generated
        protected RedisClusterDockerServiceConfigurerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RedisClusterDockerServiceConfigurer done() {
            return new RedisClusterDockerServiceConfigurer(this);
        }
    }
}

