/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.nosql.redis.api;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import pl.netroute.hussar.core.api.InternalUseOnly;
import pl.netroute.hussar.core.docker.DockerCommandLineRunner;

@InternalUseOnly
class RedisClusterWaitStrategy
extends AbstractWaitStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisClusterWaitStrategy.class);
    @NonNull
    private final DockerCommandLineRunner commandLineRunner;

    protected void waitUntilReady() {
        int timeout = (int)this.startupTimeout.getSeconds();
        Unreliables.retryUntilTrue((int)timeout, (TimeUnit)TimeUnit.SECONDS, this::isClusterReady);
    }

    private boolean isClusterReady() {
        Wait.forListeningPort().waitUntilReady(this.waitStrategyTarget);
        ClusterHealthReadinessProbe clusterHealthyReadinessProbe = new ClusterHealthReadinessProbe(this.waitStrategyTarget, this.commandLineRunner);
        return clusterHealthyReadinessProbe.isReady();
    }

    @Generated
    RedisClusterWaitStrategy(@NonNull DockerCommandLineRunner commandLineRunner) {
        if (commandLineRunner == null) {
            throw new NullPointerException("commandLineRunner is marked non-null but is null");
        }
        this.commandLineRunner = commandLineRunner;
    }

    private static class ClusterHealthReadinessProbe
    implements ReadinessProbe {
        private static final String CLUSTER_INFO_COMMAND = "redis-cli -h %s -p %d cluster info";
        private static final String CLUSTER_STATE_OK = "cluster_state:ok";
        private static final int SUCCESSFUL_COMMAND_CODE = 0;
        private final WaitStrategyTarget waitTarget;
        private final DockerCommandLineRunner commandLineRunner;

        @Override
        public boolean isReady() {
            try {
                String host = this.waitTarget.getHost();
                int port = this.getRandomClusterNodePort();
                String command = CLUSTER_INFO_COMMAND.formatted(host, port);
                Container.ExecResult result = this.commandLineRunner.runAndReturn(command, this.waitTarget);
                return result.getExitCode() == 0 && result.getStdout().contains(CLUSTER_STATE_OK);
            }
            catch (Exception ex) {
                log.error("RedisCluster readiness probe failed", (Throwable)ex);
                return false;
            }
        }

        private int getRandomClusterNodePort() {
            return (Integer)this.waitTarget.getBoundPortNumbers().getFirst();
        }

        @Generated
        private ClusterHealthReadinessProbe(WaitStrategyTarget waitTarget, DockerCommandLineRunner commandLineRunner) {
            this.waitTarget = waitTarget;
            this.commandLineRunner = commandLineRunner;
        }
    }

    private static interface ReadinessProbe {
        public boolean isReady();
    }
}

