/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.wiremock;

import lombok.Generated;
import org.testcontainers.containers.GenericContainer;
import pl.netroute.hussar.core.api.configuration.ConfigurationRegistry;
import pl.netroute.hussar.core.api.configuration.DefaultConfigurationRegistry;
import pl.netroute.hussar.core.service.BaseDockerServiceConfig;
import pl.netroute.hussar.core.service.BaseDockerServiceConfigurer;
import pl.netroute.hussar.core.service.container.GenericContainerFactory;
import pl.netroute.hussar.core.service.registerer.EndpointRegisterer;
import pl.netroute.hussar.core.service.resolver.DockerImageResolver;
import pl.netroute.hussar.core.service.resolver.ServiceNameResolver;
import pl.netroute.hussar.service.wiremock.WiremockDockerService;
import pl.netroute.hussar.service.wiremock.WiremockDockerServiceConfig;

public class WiremockDockerServiceConfigurer
extends BaseDockerServiceConfigurer<WiremockDockerService> {
    private static final String DOCKER_IMAGE = "wiremock/wiremock";
    private static final String SERVICE = "wiremock_service";

    public WiremockDockerService configure() {
        WiremockDockerServiceConfig config = this.createConfig();
        GenericContainer container = GenericContainerFactory.create((BaseDockerServiceConfig)config);
        DefaultConfigurationRegistry configurationRegistry = new DefaultConfigurationRegistry();
        EndpointRegisterer endpointRegisterer = new EndpointRegisterer((ConfigurationRegistry)configurationRegistry);
        return new WiremockDockerService(container, config, (ConfigurationRegistry)configurationRegistry, endpointRegisterer);
    }

    private WiremockDockerServiceConfig createConfig() {
        String resolvedName = ServiceNameResolver.resolve((String)SERVICE, (String)this.name);
        String resolvedDockerImage = DockerImageResolver.resolve((String)DOCKER_IMAGE, (String)this.dockerImageVersion);
        String scheme = "http://";
        return ((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)WiremockDockerServiceConfig.builder().name(resolvedName)).dockerImage(resolvedDockerImage)).scheme(scheme)).registerEndpointUnderProperties(this.registerEndpointUnderProperties)).registerEndpointUnderEnvironmentVariables(this.registerEndpointUnderEnvironmentVariables)).build();
    }

    @Generated
    protected WiremockDockerServiceConfigurer(WiremockDockerServiceConfigurerBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static WiremockDockerServiceConfigurerBuilder<?, ?> newInstance() {
        return new WiremockDockerServiceConfigurerBuilderImpl();
    }

    @Generated
    private static final class WiremockDockerServiceConfigurerBuilderImpl
    extends WiremockDockerServiceConfigurerBuilder<WiremockDockerServiceConfigurer, WiremockDockerServiceConfigurerBuilderImpl> {
        @Generated
        private WiremockDockerServiceConfigurerBuilderImpl() {
        }

        @Override
        @Generated
        protected WiremockDockerServiceConfigurerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public WiremockDockerServiceConfigurer done() {
            return new WiremockDockerServiceConfigurer(this);
        }
    }

    @Generated
    public static abstract class WiremockDockerServiceConfigurerBuilder<C extends WiremockDockerServiceConfigurer, B extends WiremockDockerServiceConfigurerBuilder<C, B>>
    extends BaseDockerServiceConfigurer.BaseDockerServiceConfigurerBuilder<WiremockDockerService, C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C done();

        @Generated
        public String toString() {
            return "WiremockDockerServiceConfigurer.WiremockDockerServiceConfigurerBuilder(super=" + super.toString() + ")";
        }
    }
}

