/*
 * Decompiled with CFR 0.152.
 */
package pl.netroute.hussar.service.wiremock.api;

import lombok.Generated;
import lombok.NonNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;
import pl.netroute.hussar.core.configuration.api.ConfigurationRegistry;
import pl.netroute.hussar.core.configuration.api.DefaultConfigurationRegistry;
import pl.netroute.hussar.core.docker.DockerImageResolver;
import pl.netroute.hussar.core.docker.DockerRegistryResolver;
import pl.netroute.hussar.core.docker.GenericContainerFactory;
import pl.netroute.hussar.core.docker.api.DockerNetwork;
import pl.netroute.hussar.core.docker.api.DockerRegistry;
import pl.netroute.hussar.core.network.api.NetworkConfigurer;
import pl.netroute.hussar.core.service.ServiceConfigureContext;
import pl.netroute.hussar.core.service.api.BaseDockerServiceConfigurer;
import pl.netroute.hussar.core.service.registerer.EndpointRegisterer;
import pl.netroute.hussar.core.service.resolver.ServiceNameResolver;
import pl.netroute.hussar.service.wiremock.api.WiremockDockerService;
import pl.netroute.hussar.service.wiremock.api.WiremockDockerServiceConfig;

public class WiremockDockerServiceConfigurer
extends BaseDockerServiceConfigurer<WiremockDockerService> {
    private static final String DOCKER_IMAGE = "wiremock/wiremock";
    private static final String SERVICE = "wiremock_service";

    public WiremockDockerService configure(@NonNull ServiceConfigureContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        DockerRegistry resolvedDockerRegistry = DockerRegistryResolver.resolve((DockerRegistry)this.dockerRegistry, (ServiceConfigureContext)context);
        DockerNetwork dockerNetwork = context.dockerNetwork();
        NetworkConfigurer networkConfigurer = context.networkConfigurer();
        DockerImageName dockerImage = DockerImageResolver.resolve((DockerRegistry)resolvedDockerRegistry, (String)DOCKER_IMAGE, (String)this.dockerImageVersion);
        WiremockDockerServiceConfig config = this.createConfig(dockerImage);
        GenericContainer container = GenericContainerFactory.create((DockerImageName)dockerImage);
        DefaultConfigurationRegistry configurationRegistry = new DefaultConfigurationRegistry();
        EndpointRegisterer endpointRegisterer = new EndpointRegisterer((ConfigurationRegistry)configurationRegistry);
        return new WiremockDockerService(container, dockerNetwork, config, (ConfigurationRegistry)configurationRegistry, endpointRegisterer, networkConfigurer);
    }

    private WiremockDockerServiceConfig createConfig(DockerImageName dockerImage) {
        String resolvedName = ServiceNameResolver.resolve((String)SERVICE, (String)this.name);
        String scheme = "http://";
        return ((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)((WiremockDockerServiceConfig.WiremockDockerServiceConfigBuilder)WiremockDockerServiceConfig.builder().name(resolvedName)).dockerImage(dockerImage.asCanonicalNameString())).startupTimeout(this.startupTimeout)).scheme(scheme)).registerEndpointUnderProperties(this.registerEndpointUnderProperties)).registerEndpointUnderEnvironmentVariables(this.registerEndpointUnderEnvironmentVariables)).build();
    }

    @Generated
    protected WiremockDockerServiceConfigurer(WiremockDockerServiceConfigurerBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static WiremockDockerServiceConfigurerBuilder<?, ?> newInstance() {
        return new WiremockDockerServiceConfigurerBuilderImpl();
    }

    @Generated
    private static final class WiremockDockerServiceConfigurerBuilderImpl
    extends WiremockDockerServiceConfigurerBuilder<WiremockDockerServiceConfigurer, WiremockDockerServiceConfigurerBuilderImpl> {
        @Generated
        private WiremockDockerServiceConfigurerBuilderImpl() {
        }

        @Override
        @Generated
        protected WiremockDockerServiceConfigurerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public WiremockDockerServiceConfigurer done() {
            return new WiremockDockerServiceConfigurer(this);
        }
    }

    @Generated
    public static abstract class WiremockDockerServiceConfigurerBuilder<C extends WiremockDockerServiceConfigurer, B extends WiremockDockerServiceConfigurerBuilder<C, B>>
    extends BaseDockerServiceConfigurer.BaseDockerServiceConfigurerBuilder<WiremockDockerService, C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C done();

        @Generated
        public String toString() {
            return "WiremockDockerServiceConfigurer.WiremockDockerServiceConfigurerBuilder(super=" + super.toString() + ")";
        }
    }
}

