/*
 * Decompiled with CFR 0.152.
 */
package pl.pragmatists.concordion.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.EventListener;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.concordion.api.AbstractCommand;
import org.concordion.api.CommandCall;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.Result;
import org.concordion.api.ResultRecorder;
import org.concordion.api.listener.AssertEqualsListener;
import org.concordion.api.listener.AssertFailureEvent;
import org.concordion.api.listener.AssertSuccessEvent;
import org.concordion.internal.util.Announcer;
import pl.pragmatists.concordion.rest.RequestExecutor;
import pl.pragmatists.concordion.rest.RestResultRenderer;
import pl.pragmatists.concordion.rest.util.JsonPrettyPrinter;

public class ExpectedJsonResponseCommand
extends AbstractCommand {
    private Announcer<AssertEqualsListener> listeners = Announcer.to(AssertEqualsListener.class);

    private static JsonElement parse(String input) {
        JsonReader reader = new JsonReader((Reader)new StringReader(input));
        reader.setLenient(true);
        return new JsonParser().parse(reader);
    }

    public ExpectedJsonResponseCommand() {
        this.listeners.addListener((EventListener)((Object)new RestResultRenderer()));
    }

    public void verify(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        Element element = commandCall.getElement();
        element.addStyleClass("json");
        JsonPrettyPrinter printer = new JsonPrettyPrinter();
        String expected = printer.prettyPrint(element.getText());
        element.moveChildrenTo(new Element("tmp"));
        element.appendText(expected);
        String mode = this.modeFrom(element);
        String actual = RequestExecutor.fromEvaluator(evaluator).getBody();
        String prettyActual = printer.prettyPrint(actual);
        if (StringUtils.isEmpty((CharSequence)actual)) {
            this.jsonDoesNotEqual(resultRecorder, element, "(not set)", expected);
            return;
        }
        try {
            if (this.comparator(mode).assertEqualsJson(prettyActual, expected)) {
                this.jsonEquals(resultRecorder, element);
            } else {
                this.jsonDoesNotEqual(resultRecorder, element, prettyActual, expected);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.jsonError(resultRecorder, element, prettyActual, expected);
        }
    }

    private JsonComparator comparator(String mode) {
        if ("includes".equals(mode)) {
            return new IncludesJsonComparator();
        }
        if ("equals".equals(mode)) {
            return new EqualsJsonComparator();
        }
        throw new IllegalArgumentException("Invalid comparition mode: " + mode);
    }

    private String modeFrom(Element element) {
        String mode = element.getAttributeValue("mode");
        return mode == null ? "includes" : mode;
    }

    protected void jsonError(ResultRecorder resultRecorder, Element element, String actual, String expected) {
        resultRecorder.record(Result.FAILURE);
        this.announceFailure(element, expected, actual);
    }

    protected void jsonDoesNotEqual(ResultRecorder resultRecorder, Element element, String actual, String expected) {
        resultRecorder.record(Result.FAILURE);
        this.announceFailure(element, expected, actual);
    }

    protected void jsonEquals(ResultRecorder resultRecorder, Element element) {
        resultRecorder.record(Result.SUCCESS);
        this.announceSuccess(element);
    }

    private void announceSuccess(Element element) {
        ((AssertEqualsListener)this.listeners.announce()).successReported(new AssertSuccessEvent(element));
    }

    private void announceFailure(Element element, String expected, Object actual) {
        ((AssertEqualsListener)this.listeners.announce()).failureReported(new AssertFailureEvent(element, expected, actual));
    }

    private static interface JsonComparator {
        public boolean assertEqualsJson(String var1, String var2);
    }

    private static class IncludesJsonComparator
    implements JsonComparator {
        private IncludesJsonComparator() {
        }

        @Override
        public boolean assertEqualsJson(String actual, String expected) {
            JsonElement actualJson = ExpectedJsonResponseCommand.parse(actual);
            JsonElement expectedJson = ExpectedJsonResponseCommand.parse(expected);
            return this.includesJson(actualJson, expectedJson);
        }

        private boolean includesJson(JsonElement actualJson, JsonElement expectedJson) {
            if (expectedJson.isJsonObject()) {
                if (!actualJson.isJsonObject()) {
                    return false;
                }
                for (Map.Entry entry : expectedJson.getAsJsonObject().entrySet()) {
                    String property = (String)entry.getKey();
                    JsonElement expectedValue = (JsonElement)entry.getValue();
                    if (!actualJson.getAsJsonObject().has(property)) {
                        return false;
                    }
                    JsonElement actualValue = actualJson.getAsJsonObject().get(property);
                    if (this.includesJson(actualValue, expectedValue)) continue;
                    return false;
                }
                return true;
            }
            if (expectedJson.isJsonArray()) {
                if (!actualJson.isJsonArray()) {
                    return false;
                }
                block1: for (JsonElement expectedItem : expectedJson.getAsJsonArray()) {
                    for (JsonElement candidateItem : actualJson.getAsJsonArray()) {
                        if (!this.includesJson(candidateItem, expectedItem)) continue;
                        continue block1;
                    }
                    return false;
                }
                return true;
            }
            return actualJson.equals(expectedJson);
        }
    }

    private static class EqualsJsonComparator
    implements JsonComparator {
        private EqualsJsonComparator() {
        }

        @Override
        public boolean assertEqualsJson(String actual, String expected) {
            JsonElement actualJson = ExpectedJsonResponseCommand.parse(actual);
            JsonElement expectedJson = ExpectedJsonResponseCommand.parse(expected);
            return actualJson.equals(expectedJson);
        }
    }
}

