/*
 * Decompiled with CFR 0.152.
 */
package pl.pragmatists.concordion.rest;

import java.util.EventListener;
import org.concordion.api.AbstractCommand;
import org.concordion.api.CommandCall;
import org.concordion.api.Element;
import org.concordion.api.Evaluator;
import org.concordion.api.Result;
import org.concordion.api.ResultRecorder;
import org.concordion.api.listener.AssertEqualsListener;
import org.concordion.api.listener.AssertFailureEvent;
import org.concordion.api.listener.AssertSuccessEvent;
import org.concordion.internal.listener.AssertResultRenderer;
import org.concordion.internal.util.Announcer;
import pl.pragmatists.concordion.rest.RequestExecutor;

public class ExpectedStatusCommand
extends AbstractCommand {
    private Announcer<AssertEqualsListener> listeners = Announcer.to(AssertEqualsListener.class);

    public ExpectedStatusCommand() {
        this.listeners.addListener((EventListener)new AssertResultRenderer());
    }

    public void verify(CommandCall commandCall, Evaluator evaluator, ResultRecorder resultRecorder) {
        String expectedStatus = commandCall.getElement().getText();
        RequestExecutor response = RequestExecutor.fromEvaluator(evaluator);
        String actualStatus = response.getStatusLine();
        System.err.println("STATUS(Expected): " + expectedStatus);
        System.err.println("STATUS(Actual): " + actualStatus);
        if (expectedStatus.equals(actualStatus)) {
            resultRecorder.record(Result.SUCCESS);
            this.announceSuccess(commandCall.getElement());
        } else {
            resultRecorder.record(Result.FAILURE);
            this.announceFailure(commandCall.getElement(), expectedStatus, actualStatus);
        }
    }

    private void announceSuccess(Element element) {
        ((AssertEqualsListener)this.listeners.announce()).successReported(new AssertSuccessEvent(element));
    }

    private void announceFailure(Element element, String expected, Object actual) {
        ((AssertEqualsListener)this.listeners.announce()).failureReported(new AssertFailureEvent(element, expected, actual));
    }
}

