/*
 * Decompiled with CFR 0.152.
 */
package pl.pragmatists.concordion.rest;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.concordion.api.Evaluator;
import pl.pragmatists.concordion.rest.RestExtension;

public class RequestExecutor {
    private RequestSpecification request;
    private Response response;
    private String method;
    private String url;
    private String body;
    private Map<String, String> headers = new HashMap<String, String>();
    protected static final String REQUEST_EXECUTOR_VARIABLE = "#request";
    private RestExtension.Config config;

    public RequestExecutor(RestExtension.Config config) {
        this.request = (RequestSpecification)RestAssured.given().urlEncodingEnabled(false).port(config.port).baseUri(config.host).log().all(true);
        this.config = config;
    }

    public RequestExecutor method(String method) {
        this.method = method;
        return this;
    }

    public RequestExecutor url(String url) {
        this.url = url;
        return this;
    }

    public void execute() {
        if ("GET".equals(this.method)) {
            this.response = (Response)this.request.get(this.url, new Object[0]);
            return;
        }
        if ("POST".equals(this.method)) {
            this.response = (Response)this.request.post(this.url, new Object[0]);
            return;
        }
        if ("PUT".equals(this.method)) {
            this.response = (Response)this.request.put(this.url, new Object[0]);
            return;
        }
        if ("DELETE".equals(this.method)) {
            this.response = (Response)this.request.delete(this.url, new Object[0]);
            return;
        }
        if ("PATCH".equals(this.method)) {
            this.response = (Response)this.request.patch(this.url, new Object[0]);
            return;
        }
    }

    public RequestExecutor header(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
        this.request.header(headerName, (Object)headerValue, new Object[0]);
        return this;
    }

    public String getHeader(String attributeValue) {
        return this.replacePlaceholdersIfNeeded(this.response.getHeader(attributeValue));
    }

    public String getStatusLine() {
        return this.response.getStatusLine();
    }

    public RequestExecutor body(String body) {
        this.body = body;
        this.request.body(body);
        return this;
    }

    public String getBody() {
        return this.replacePlaceholdersIfNeeded(this.response.body().asString());
    }

    private String replacePlaceholdersIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        if (this.config.enablePlaceholders) {
            string = this.replaceWith(string, "https://" + this.config.host + ":" + this.config.port, "https://{host:port}");
            string = this.replaceWith(string, "https://" + this.config.host, "https://{host}");
            string = this.replaceWith(string, "http://" + this.config.host + ":" + this.config.port, "http://{host:port}");
            string = this.replaceWith(string, "http://" + this.config.host, "http://{host}");
            if (this.response.getSessionId() != null) {
                string = this.replaceWith(string, this.response.getSessionId(), "{sessionId}");
            }
        }
        return string;
    }

    private String replaceWith(String string, String replace, String replacement) {
        return string.replaceAll(replace, replacement);
    }

    public InputStream getBodyAsInputStream() {
        return this.response.asInputStream();
    }

    public static RequestExecutor fromEvaluator(Evaluator evaluator) {
        return (RequestExecutor)evaluator.getVariable(REQUEST_EXECUTOR_VARIABLE);
    }

    public static RequestExecutor newExecutor(Evaluator evaluator, RestExtension.Config config) {
        RequestExecutor variable = new RequestExecutor(config);
        evaluator.setVariable(REQUEST_EXECUTOR_VARIABLE, (Object)variable);
        return variable;
    }

    public boolean wasSuccessfull() {
        int statusCode = this.response.getStatusCode();
        return statusCode >= 200 && statusCode < 400;
    }

    public String getRequestUrl() {
        return this.url;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public String getRequestBody() {
        return this.body;
    }

    public String getRequestHeader(String header) {
        return this.headers.get(header);
    }
}

