/*
 * Decompiled with CFR 0.152.
 */
package pl.pragmatists.concordion.rest;

import java.util.HashMap;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.concordion.api.Command;
import org.concordion.api.extension.ConcordionExtender;
import org.concordion.api.extension.ConcordionExtension;
import org.concordion.api.listener.DocumentParsingListener;
import pl.pragmatists.concordion.rest.ExpectedAttachmentCommand;
import pl.pragmatists.concordion.rest.ExpectedHeaderCommand;
import pl.pragmatists.concordion.rest.ExpectedJsonResponseCommand;
import pl.pragmatists.concordion.rest.ExpectedStatusCommand;
import pl.pragmatists.concordion.rest.ExpectedSuccessCommand;
import pl.pragmatists.concordion.rest.ExpectedXmlResponseCommand;
import pl.pragmatists.concordion.rest.HttpMethodCommand;
import pl.pragmatists.concordion.rest.JsonBodyCommand;
import pl.pragmatists.concordion.rest.RequestCommand;
import pl.pragmatists.concordion.rest.SetHeaderCommand;
import pl.pragmatists.concordion.rest.bootstrap.BootstrapExtension;
import pl.pragmatists.concordion.rest.codemirror.CodeMirrorExtension;

public class RestExtension
implements ConcordionExtension {
    public static final String REST_EXTENSION_NS = "http://pragmatists.github.io/concordion-rest-extension";
    private Config config = new Config();

    public RestExtension enableCodeMirror() {
        this.config.codeMirrorEnabled = true;
        return this;
    }

    public RestExtension includeBootstrap() {
        this.config.includeBootstrap = true;
        return this;
    }

    public RestExtension host(String host) {
        if (!host.startsWith("http")) {
            host = "http://" + host;
        }
        this.config.host = host;
        return this;
    }

    public RestExtension port(int port) {
        this.config.port = port;
        return this;
    }

    public void addTo(ConcordionExtender concordionExtender) {
        if (this.config.codeMirrorEnabled) {
            new CodeMirrorExtension().addTo(concordionExtender);
        }
        if (this.config.includeBootstrap) {
            new BootstrapExtension().addTo(concordionExtender);
        }
        concordionExtender.withCommand(REST_EXTENSION_NS, "request", (Command)new RequestCommand(this.config));
        concordionExtender.withCommand(REST_EXTENSION_NS, "get", (Command)new HttpMethodCommand("GET"));
        concordionExtender.withCommand(REST_EXTENSION_NS, "post", (Command)new HttpMethodCommand("POST"));
        concordionExtender.withCommand(REST_EXTENSION_NS, "put", (Command)new HttpMethodCommand("PUT"));
        concordionExtender.withCommand(REST_EXTENSION_NS, "delete", (Command)new HttpMethodCommand("DELETE"));
        concordionExtender.withCommand(REST_EXTENSION_NS, "patch", (Command)new HttpMethodCommand("PATCH"));
        concordionExtender.withCommand(REST_EXTENSION_NS, "jsonBody", (Command)new JsonBodyCommand());
        concordionExtender.withCommand(REST_EXTENSION_NS, "setHeader", (Command)new SetHeaderCommand());
        concordionExtender.withCommand(REST_EXTENSION_NS, "status", (Command)new ExpectedStatusCommand());
        concordionExtender.withCommand(REST_EXTENSION_NS, "success", (Command)new ExpectedSuccessCommand());
        concordionExtender.withCommand(REST_EXTENSION_NS, "header", (Command)new ExpectedHeaderCommand());
        concordionExtender.withCommand(REST_EXTENSION_NS, "jsonResponse", (Command)new ExpectedJsonResponseCommand());
        concordionExtender.withCommand(REST_EXTENSION_NS, "xmlResponse", (Command)new ExpectedXmlResponseCommand());
        concordionExtender.withCommand(REST_EXTENSION_NS, "attachment", (Command)new ExpectedAttachmentCommand(concordionExtender));
        concordionExtender.withDocumentParsingListener(new DocumentParsingListener(){
            private Map<String, String> tags = new HashMap<String, String>(){
                {
                    this.put("request", "div");
                    this.put("get", "code");
                    this.put("post", "code");
                    this.put("put", "code");
                    this.put("delete", "code");
                    this.put("patch", "code");
                    this.put("jsonBody", "pre");
                    this.put("setHeader", "code");
                    this.put("status", "code");
                    this.put("success", "span");
                    this.put("header", "code");
                    this.put("jsonResponse", "pre");
                    this.put("xmlResponse", "pre");
                    this.put("attachment", "code");
                }
            };

            public void beforeParsing(Document document) {
                this.visit(document.getRootElement());
            }

            private void visit(Element elem) {
                Elements children = elem.getChildElements();
                for (int i = 0; i < children.size(); ++i) {
                    this.visit(children.get(i));
                }
                if (RestExtension.REST_EXTENSION_NS.equals(elem.getNamespaceURI())) {
                    Attribute attr = new Attribute(elem.getLocalName(), "");
                    attr.setNamespace("r", RestExtension.REST_EXTENSION_NS);
                    elem.addAttribute(attr);
                    elem.setNamespacePrefix("");
                    elem.setNamespaceURI(null);
                    elem.setLocalName(this.translateTag(elem.getLocalName()));
                }
            }

            private String translateTag(String localName) {
                String name = this.tags.get(localName);
                return name == null ? localName : name;
            }
        });
    }

    public RestExtension disablePlaceholders() {
        this.config.enablePlaceholders = false;
        return this;
    }

    static class Config {
        boolean codeMirrorEnabled = false;
        boolean includeBootstrap = false;
        int port = 8080;
        String host = "http://localhost";
        boolean enablePlaceholders = true;

        Config() {
        }
    }
}

