/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgoogl;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.ning.http.client.AsyncHttpClient;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import pl.project13.jgoogl.JGooGlWithAnalytics;
import pl.project13.jgoogl.conf.GooGlProjection;
import pl.project13.jgoogl.conf.GooGlVersion;
import pl.project13.jgoogl.exceptions.InvalidGooGlUrlException;
import pl.project13.jgoogl.gson.GooGlGsonProvider;
import pl.project13.jgoogl.request.v1.RequestBuilder;
import pl.project13.jgoogl.response.v1.AnalyticsResponse;
import pl.project13.jgoogl.response.v1.ExpandResponse;
import pl.project13.jgoogl.response.v1.ShortenResponse;

public class JGooGl {
    private Gson gson;
    private AsyncHttpClient asyncHttpClient;
    private RequestBuilder requestBuilder;
    @VisibleForTesting
    JGooGlContext defaultContext = new JGooGlContext();
    @VisibleForTesting
    JGooGlContext flowContext = new JGooGlContext();

    private JGooGl(Gson gson, AsyncHttpClient asyncHttpClient) {
        this.gson = gson;
        this.asyncHttpClient = asyncHttpClient;
    }

    private JGooGl() {
        this(GooGlGsonProvider.get(), new AsyncHttpClient());
        this.requestBuilder = new RequestBuilder(this.asyncHttpClient, this.gson);
    }

    private JGooGl(String apiKey) {
        this();
        this.defaultContext.apiKey = apiKey;
    }

    public static JGooGl withKey(String key) {
        return new JGooGl(key);
    }

    public static JGooGl withoutKey() {
        return new JGooGl();
    }

    public JGooGl onKey(String key) {
        this.flowContext.apiKey = key;
        return this;
    }

    public JGooGl onNoKey() {
        this.flowContext.apiKey = null;
        return this;
    }

    public JGooGl onVersion(GooGlVersion version) {
        this.flowContext.apiVersion = version;
        return this;
    }

    public JGooGlWithAnalytics onProjection(GooGlProjection projection) {
        return this.withAnalytics(projection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortenResponse shorten(String longUrl) throws IOException, ExecutionException, InterruptedException {
        try {
            RequestBuilder builder = this.requestBuilder.apiKey(this.flowContext.apiKey).apiVersion(this.flowContext.apiVersion).projection(this.flowContext.projection).shorten(longUrl);
            String responseBody = builder.execute();
            ShortenResponse shortenResponse = (ShortenResponse)this.gson.fromJson(responseBody, ShortenResponse.class);
            return shortenResponse;
        }
        finally {
            this.clearFlowContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpandResponse expand(String shortUrl) throws IOException, ExecutionException, InterruptedException {
        try {
            ExpandResponse expandResponse;
            this.throwIfNotGooGlUrl(shortUrl);
            RequestBuilder builder = this.requestBuilder.apiKey(this.flowContext.apiKey).projection(this.flowContext.projection).expand(shortUrl);
            String responseBody = builder.execute();
            ExpandResponse expandResponse2 = expandResponse = this.parseExpandResponse(responseBody);
            return expandResponse2;
        }
        finally {
            this.clearFlowContext();
        }
    }

    public AnalyticsResponse analyticsFor(String shortUrl) throws IOException, ExecutionException, InterruptedException {
        return this.analyticsFor(shortUrl, this.defaultContext.projection);
    }

    public AnalyticsResponse analyticsFor(String shortUrl, GooGlProjection projection) throws IOException, ExecutionException, InterruptedException {
        return this.withAnalytics(projection).expand(shortUrl);
    }

    public JGooGlWithAnalytics withAnalytics(GooGlProjection projection) {
        this.flowContext.projection = projection;
        return new JGooGlWithAnalytics(this);
    }

    private ExpandResponse parseExpandResponse(String responseBody) {
        return (ExpandResponse)this.gson.fromJson(responseBody, AnalyticsResponse.class);
    }

    private void throwIfNotGooGlUrl(String url) {
        if (!(url.startsWith("goo.gl/") || url.startsWith("http://www.goo.gl/") || url.startsWith("http://goo.gl/"))) {
            throw new InvalidGooGlUrlException("It seems that the url: '" + url + "' is invalid...");
        }
    }

    private void clearFlowContext() {
        this.flowContext.apiKey = this.defaultContext.apiKey;
        this.flowContext.apiVersion = this.defaultContext.apiVersion;
        this.flowContext.projection = this.defaultContext.projection;
    }

    @VisibleForTesting
    public void setRequestBuilder(RequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    @VisibleForTesting
    public RequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public static class Builder {
        private JGooGl instance = new JGooGl();

        public Builder useSupplied(Gson gson) {
            this.instance.gson = gson;
            return this;
        }

        public Builder useSupplied(AsyncHttpClient asyncHttpClient) {
            this.instance.asyncHttpClient = asyncHttpClient;
            return this;
        }

        public Builder useKey(String apiKey) {
            this.instance.defaultContext.apiKey = apiKey;
            return this;
        }

        public Builder useVersion(GooGlVersion version) {
            this.instance.defaultContext.apiVersion = version;
            return this;
        }

        public Builder useProjection(GooGlProjection projection) {
            this.instance.defaultContext.projection = projection;
            return this;
        }

        public JGooGl get() {
            return this.instance;
        }
    }

    class JGooGlContext {
        String apiKey = null;
        GooGlVersion apiVersion = GooGlVersion.V1;
        GooGlProjection projection = GooGlProjection.ANALYTICS_CLICKS;

        JGooGlContext() {
        }
    }
}

