/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgoogl.request.v1;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import pl.project13.jgoogl.conf.GooGlProjection;
import pl.project13.jgoogl.conf.GooGlVersion;
import pl.project13.jgoogl.exceptions.GooGlResponseFailureException;
import pl.project13.jgoogl.utils.StringUtils;

public class RequestBuilder {
    private Logger log = Logger.getLogger(this.getClass());
    private AsyncHttpClient asyncHttpClient;
    private Gson gson;
    private final String APP_JSON = "application/json";
    private final String API_KEY = "key";
    private final String SHORT_URL = "shortUrl";
    private final String LONG_URL = "longUrl";
    private final String PROJECTION = "projection";
    private GooGlVersion version = GooGlVersion.V1;
    private GooGlProjection projection = GooGlProjection.ANALYTICS_CLICKS;
    private Map<String, String> params = Maps.newHashMap();

    public RequestBuilder(AsyncHttpClient asyncHttpClient, Gson gson) {
        this.asyncHttpClient = asyncHttpClient;
        this.gson = gson;
    }

    public RequestBuilder apiKey(String apiKey) {
        if (!StringUtils.hasText(apiKey)) {
            this.params.remove("key");
        } else {
            this.params.put("key", apiKey);
        }
        return this;
    }

    public RequestBuilder shorten(String longUrl) {
        this.params.remove("shortUrl");
        this.params.put("longUrl", longUrl);
        return this;
    }

    public RequestBuilder expand(String shortUrl) {
        this.params.remove("longUrl");
        this.params.put("shortUrl", this.urlEncode(shortUrl));
        return this;
    }

    public RequestBuilder projection(GooGlProjection projection) {
        this.projection = projection;
        return this;
    }

    public RequestBuilder apiVersion(GooGlVersion apiVersion) {
        this.version = apiVersion;
        return this;
    }

    public String execute() throws IOException, ExecutionException, InterruptedException {
        AsyncHttpClient.BoundRequestBuilder builder = this.prepareBuilder();
        Future futureResponse = builder.execute();
        Response response = (Response)futureResponse.get();
        String responseBody = response.getResponseBody();
        if (!StringUtils.hasText(responseBody)) {
            throw new GooGlResponseFailureException("Got invalid response.", response);
        }
        this.log.info((Object)("GOT: " + responseBody));
        return responseBody;
    }

    private AsyncHttpClient.BoundRequestBuilder prepareBuilder() {
        AsyncHttpClient.BoundRequestBuilder builder;
        if (this.shouldUsePost()) {
            String url = this.version.serviceUrl;
            String data = this.gson.toJson(this.params);
            this.log.info((Object)("POST: " + url + " with data: " + data));
            builder = this.asyncHttpClient.preparePost(url).setBody(data);
        } else {
            String url = this.prepareGetUrl(this.version.serviceUrl);
            this.log.info((Object)("GET: " + url + " with params: " + "projection" + " = " + this.projection.urlParamValue));
            builder = this.asyncHttpClient.prepareGet(url);
        }
        builder.addHeader("Content-type", "application/json").addHeader("Accept", "application/json");
        return builder;
    }

    private String prepareGetUrl(String serviceUrl) {
        this.params.put("projection", this.projection.urlParamValue);
        String queryUrl = serviceUrl + "?" + Joiner.on((String)"&").withKeyValueSeparator("=").join(this.params);
        this.params = Maps.newHashMap();
        return queryUrl;
    }

    private String urlEncode(String value) {
        String encode = value;
        try {
            encode = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)"Could not urlEncode parameter", (Throwable)e);
        }
        return encode;
    }

    private boolean shouldUsePost() {
        return this.params.containsKey("longUrl");
    }
}

