/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import pl.project13.core.AheadBehind;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.GitDataProvider;
import pl.project13.core.jgit.DescribeCommand;
import pl.project13.core.jgit.DescribeResult;
import pl.project13.core.jgit.JGitCommon;
import pl.project13.core.log.LoggerBridge;

public class JGitProvider
extends GitDataProvider {
    private File dotGitDirectory;
    private Repository git;
    private ObjectReader objectReader;
    private RevWalk revWalk;
    private RevCommit evalCommit;
    private JGitCommon jGitCommon;

    @Nonnull
    public static JGitProvider on(@Nonnull File dotGitDirectory, @Nonnull LoggerBridge log) {
        return new JGitProvider(dotGitDirectory, log);
    }

    JGitProvider(@Nonnull File dotGitDirectory, @Nonnull LoggerBridge log) {
        super(log);
        this.dotGitDirectory = dotGitDirectory;
        this.jGitCommon = new JGitCommon(log);
    }

    @Override
    public void init() throws GitCommitIdExecutionException {
        this.git = this.getGitRepository();
        this.objectReader = this.git.newObjectReader();
    }

    @Override
    public String getBuildAuthorName() throws GitCommitIdExecutionException {
        String userName = this.git.getConfig().getString("user", null, "name");
        return Optional.ofNullable(userName).orElse("");
    }

    @Override
    public String getBuildAuthorEmail() throws GitCommitIdExecutionException {
        String userEmail = this.git.getConfig().getString("user", null, "email");
        return Optional.ofNullable(userEmail).orElse("");
    }

    @Override
    public void prepareGitToExtractMoreDetailedRepoInformation() throws GitCommitIdExecutionException {
        try {
            Ref evaluateOnCommitReference = this.git.findRef(this.evaluateOnCommit);
            ObjectId evaluateOnCommitResolvedObjectId = this.git.resolve(this.evaluateOnCommit);
            if (evaluateOnCommitReference == null && evaluateOnCommitResolvedObjectId == null) {
                throw new GitCommitIdExecutionException("Could not get " + this.evaluateOnCommit + " Ref, are you sure you have set the dotGitDirectory property of this plugin to a valid path?");
            }
            this.revWalk = new RevWalk(this.git);
            ObjectId headObjectId = evaluateOnCommitReference != null ? evaluateOnCommitReference.getObjectId() : evaluateOnCommitResolvedObjectId;
            if (headObjectId == null) {
                throw new GitCommitIdExecutionException("Could not get " + this.evaluateOnCommit + " Ref, are you sure you have some commits in the dotGitDirectory?");
            }
            this.evalCommit = this.revWalk.parseCommit((AnyObjectId)headObjectId);
            this.revWalk.markStart(this.evalCommit);
        }
        catch (Exception e) {
            throw new GitCommitIdExecutionException("Error", e);
        }
    }

    @Override
    public String getBranchName() throws GitCommitIdExecutionException {
        try {
            if (this.evalCommitIsNotHead()) {
                return this.getBranchForCommitish();
            }
            return this.getBranchForHead();
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException(e);
        }
    }

    private String getBranchForHead() throws IOException {
        return this.git.getBranch();
    }

    private String getBranchForCommitish() throws GitCommitIdExecutionException {
        try {
            String commitId = this.getCommitId();
            boolean evaluateOnCommitPointsToTag = this.git.getRefDatabase().getRefsByPrefix("refs/tags/").stream().anyMatch(ref -> Repository.shortenRefName((String)ref.getName()).equalsIgnoreCase(this.evaluateOnCommit));
            if (evaluateOnCommitPointsToTag) {
                return commitId;
            }
            List branchesForCommit = this.git.getRefDatabase().getRefsByPrefix("refs/heads/").stream().filter(ref -> commitId.equals(ref.getObjectId().name())).map(ref -> Repository.shortenRefName((String)ref.getName())).distinct().sorted().collect(Collectors.toList());
            String branch = branchesForCommit.stream().collect(Collectors.joining(","));
            if (branch != null && !branch.isEmpty()) {
                return branch;
            }
            return commitId;
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException(e);
        }
    }

    private boolean evalCommitIsNotHead() {
        return this.evaluateOnCommit != null && !this.evaluateOnCommit.equals("HEAD");
    }

    @Override
    public String getGitDescribe() throws GitCommitIdExecutionException {
        return this.getGitDescribe(this.git);
    }

    @Override
    public String getCommitId() throws GitCommitIdExecutionException {
        return this.evalCommit.getName();
    }

    @Override
    public String getAbbrevCommitId() throws GitCommitIdExecutionException {
        return this.getAbbrevCommitId(this.objectReader, this.evalCommit, this.abbrevLength);
    }

    @Override
    public boolean isDirty() throws GitCommitIdExecutionException {
        try {
            return JGitCommon.isRepositoryInDirtyState(this.git);
        }
        catch (GitAPIException e) {
            throw new GitCommitIdExecutionException("Failed to get git status: " + e.getMessage(), e);
        }
    }

    @Override
    public String getCommitAuthorName() throws GitCommitIdExecutionException {
        return this.evalCommit.getAuthorIdent().getName();
    }

    @Override
    public String getCommitAuthorEmail() throws GitCommitIdExecutionException {
        return this.evalCommit.getAuthorIdent().getEmailAddress();
    }

    @Override
    public String getCommitMessageFull() throws GitCommitIdExecutionException {
        return this.evalCommit.getFullMessage().trim();
    }

    @Override
    public String getCommitMessageShort() throws GitCommitIdExecutionException {
        return this.evalCommit.getShortMessage().trim();
    }

    @Override
    public String getCommitTime() throws GitCommitIdExecutionException {
        long timeSinceEpoch = this.evalCommit.getCommitTime();
        Date commitDate = new Date(timeSinceEpoch * 1000L);
        SimpleDateFormat smf = this.getSimpleDateFormatWithTimeZone();
        return smf.format(commitDate);
    }

    @Override
    public String getCommitAuthorTime() throws GitCommitIdExecutionException {
        Date commitAuthorDate = this.evalCommit.getAuthorIdent().getWhen();
        SimpleDateFormat smf = this.getSimpleDateFormatWithTimeZone();
        return smf.format(commitAuthorDate);
    }

    @Override
    public String getCommitCommitterTime() throws GitCommitIdExecutionException {
        Date commitCommitterDate = this.evalCommit.getCommitterIdent().getWhen();
        SimpleDateFormat smf = this.getSimpleDateFormatWithTimeZone();
        return smf.format(commitCommitterDate);
    }

    @Override
    public String getRemoteOriginUrl() throws GitCommitIdExecutionException {
        String url = this.git.getConfig().getString("remote", "origin", "url");
        return this.stripCredentialsFromOriginUrl(url);
    }

    @Override
    public String getTags() throws GitCommitIdExecutionException {
        try {
            Repository repo = this.getGitRepository();
            ObjectId headId = this.evalCommit.toObjectId();
            Collection<String> tags = this.jGitCommon.getTags(repo, headId);
            return String.join((CharSequence)",", tags);
        }
        catch (GitAPIException e) {
            this.log.error("Unable to extract tags from commit: {} ({})", (Object)this.evalCommit.getName(), (Object)((Object)((Object)e)).getClass().getName());
            return "";
        }
    }

    @Override
    public String getClosestTagName() throws GitCommitIdExecutionException {
        Repository repo = this.getGitRepository();
        try {
            return this.jGitCommon.getClosestTagName(this.evaluateOnCommit, repo, this.gitDescribe);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    public String getClosestTagCommitCount() throws GitCommitIdExecutionException {
        Repository repo = this.getGitRepository();
        try {
            return this.jGitCommon.getClosestTagCommitCount(this.evaluateOnCommit, repo, this.gitDescribe);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    public String getTotalCommitCount() throws GitCommitIdExecutionException {
        try {
            return String.valueOf(RevWalkUtils.count((RevWalk)this.revWalk, (RevCommit)this.evalCommit, null));
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    public void finalCleanUp() {
        if (this.revWalk != null) {
            this.revWalk.dispose();
        }
        if (this.git != null) {
            this.git.close();
            WindowCacheConfig config = new WindowCacheConfig();
            config.install();
        }
    }

    String getGitDescribe(@Nonnull Repository repository) throws GitCommitIdExecutionException {
        try {
            DescribeResult describeResult = DescribeCommand.on(this.evaluateOnCommit, repository, this.log).apply(this.gitDescribe).call();
            return describeResult.toString();
        }
        catch (GitAPIException ex) {
            ex.printStackTrace();
            throw new GitCommitIdExecutionException("Unable to obtain git.commit.id.describe information", ex);
        }
    }

    private String getAbbrevCommitId(ObjectReader objectReader, RevCommit headCommit, int abbrevLength) throws GitCommitIdExecutionException {
        try {
            AbbreviatedObjectId abbreviatedObjectId = objectReader.abbreviate((AnyObjectId)headCommit, abbrevLength);
            return abbreviatedObjectId.name();
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException("Unable to abbreviate commit id! You may want to investigate the <abbrevLength/> element in your configuration.", e);
        }
    }

    @Nonnull
    private Repository getGitRepository() throws GitCommitIdExecutionException {
        Repository repository;
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.setGitDir(this.dotGitDirectory)).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException("Could not initialize repository...", e);
        }
        if (repository == null) {
            throw new GitCommitIdExecutionException("Could not create git repository. Are you sure '" + this.dotGitDirectory + "' is the valid Git root for your project?");
        }
        return repository;
    }

    @Override
    public AheadBehind getAheadBehind() throws GitCommitIdExecutionException {
        try {
            if (!this.offline) {
                this.fetch();
            }
            Optional<BranchTrackingStatus> branchTrackingStatus = Optional.ofNullable(BranchTrackingStatus.of((Repository)this.git, (String)this.getBranchName()));
            return branchTrackingStatus.map(bts -> AheadBehind.of(bts.getAheadCount(), bts.getBehindCount())).orElse(AheadBehind.NO_REMOTE);
        }
        catch (Exception e) {
            throw new GitCommitIdExecutionException("Failed to read ahead behind count: " + e.getMessage(), e);
        }
    }

    private void fetch() {
        FetchCommand fetchCommand = Git.wrap((Repository)this.git).fetch();
        try {
            fetchCommand.setThin(true).call();
        }
        catch (Exception e) {
            this.log.error("Failed to perform fetch", e);
        }
    }

    public void setRepository(Repository git) {
        this.git = git;
    }
}

