/*
 * Copyright 2015 RSPECTIVE P RYCHLIK SPÓŁKA JAWNA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.rspective.opengdansk.rss.api;

import pl.rspective.opengdansk.rss.model.RssResponse;
import pl.rspective.opengdansk.rss.rest.async.OpenGdanskRssAsyncApi;
import retrofit.Callback;

public class OpenGdanskAsync implements OpenGdanskRssApi<Void, Callback<RssResponse>> {

    private OpenGdanskRssAsyncApi asyncApi;

    public OpenGdanskAsync(OpenGdanskRssAsyncApi asyncApi) {
        this.asyncApi = asyncApi;
    }

    @Override
    public Void provideNews(Callback<RssResponse> callback) {
        asyncApi.downloadNews(callback);
        return null;
    }

    @Override
    public Void provideStatements(Callback<RssResponse> callback) {
        asyncApi.downloadStatements(callback);
        return null;
    }

    @Override
    public Void provideContests(Callback<RssResponse> callback) {
        asyncApi.downloadContests(callback);
        return null;
    }

    @Override
    public Void provideJobs(Callback<RssResponse> callback) {
        asyncApi.downloadJobs(callback);
        return null;
    }

    @Override
    public Void provideCulture(Callback<RssResponse> callback) {
        asyncApi.downloadCultue(callback);
        return null;
    }

    @Override
    public Void provideSports(Callback<RssResponse> callback) {
        asyncApi.downloadSport(callback);
        return null;
    }
}
