/*
 * Copyright 2015 RSPECTIVE P RYCHLIK SPÓŁKA JAWNA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.rspective.opengdansk.rss.api;

import pl.rspective.opengdansk.rss.model.RssResponse;
import pl.rspective.opengdansk.rss.rest.rx.OpenGdanskRssRxApi;
import rx.Observer;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

public class OpenGdanskRx implements OpenGdanskRssApi<Subscription, Observer<RssResponse>> {

    private OpenGdanskRssRxApi rxApi;

    public OpenGdanskRx(OpenGdanskRssRxApi rxApi) {
        this.rxApi = rxApi;
    }

    @Override
    public Subscription provideNews(Observer<RssResponse> observer) {
        return rxApi
                .downloadNews()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }

    @Override
    public Subscription provideStatements(Observer<RssResponse> observer) {
        return rxApi
                .downloadStatements()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }

    @Override
    public Subscription provideContests(Observer<RssResponse> observer) {
        return rxApi
                .downloadContests()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }

    @Override
    public Subscription provideJobs(Observer<RssResponse> observer) {
        return rxApi
                .downloadJobs()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }

    @Override
    public Subscription provideCulture(Observer<RssResponse> observer) {
        return rxApi
                .downloadCultue()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }

    @Override
    public Subscription provideSports(Observer<RssResponse> observer) {
        return rxApi
                .downloadSport()
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }
}
