/*
 * Copyright 2015 RSPECTIVE P RYCHLIK SPÓŁKA JAWNA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.rspective.opengdansk.rss.api;

import pl.rspective.opengdansk.rss.model.RssResponse;
import pl.rspective.opengdansk.rss.rest.sync.OpenGdanskRssSyncApi;

public class OpenGdanskSync implements OpenGdanskRssApi<RssResponse, Void> {

    private OpenGdanskRssSyncApi syncApi;

    public OpenGdanskSync(OpenGdanskRssSyncApi syncApi) {
        this.syncApi = syncApi;
    }

    @Override
    public RssResponse provideNews(Void aVoid) {
        return syncApi.downloadNews();
    }

    @Override
    public RssResponse provideStatements(Void aVoid) {
        return syncApi.downloadStatements();
    }

    @Override
    public RssResponse provideContests(Void aVoid) {
        return syncApi.downloadContests();
    }

    @Override
    public RssResponse provideJobs(Void aVoid) {
        return syncApi.downloadJobs();
    }

    @Override
    public RssResponse provideCulture(Void aVoid) {
        return syncApi.downloadCultue();
    }

    @Override
    public RssResponse provideSports(Void aVoid) {
        return syncApi.downloadSport();
    }
}
