/*
 * Copyright 2015 RSPECTIVE P RYCHLIK SPÓŁKA JAWNA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package pl.rspective.opengdansk.rss.rest.async;

import pl.rspective.opengdansk.rss.model.RssResponse;
import retrofit.Callback;
import retrofit.http.GET;

public interface OpenGdanskRssAsyncApi {

    @GET("/subpages/rss/wiadomosci_rss.xml")
    void downloadNews(Callback<RssResponse> callback);

    @GET("/subpages/rss/komunikaty_rss.xml")
    void downloadStatements(Callback<RssResponse> callback);

    @GET("/subpages/rss/konkursy_rss.xml")
    void downloadContests(Callback<RssResponse> callback);

    @GET("/subpages/rss/praca_rss.xml")
    void downloadJobs(Callback<RssResponse> callback);

    @GET("/subpages/rss/kultura_rss.xml")
    void downloadCultue(Callback<RssResponse> callback);

    @GET("/subpages/rss/sport_rss.xml")
    void downloadSport(Callback<RssResponse> callback);

}
