/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.module;

import java.util.List;
import java.util.concurrent.Executor;
import pl.rspective.voucherify.client.api.VoucherifyApi;
import pl.rspective.voucherify.client.callback.VoucherifyCallback;
import pl.rspective.voucherify.client.model.Voucher;
import pl.rspective.voucherify.client.module.AbsModule;
import pl.rspective.voucherify.client.utils.RxUtils;
import rx.Observable;

abstract class BaseModule<T, R>
extends AbsModule<ExtAsync, ExtRxJava> {
    public BaseModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    public List<T> fetchAll() {
        return this.api.fetchAllVouchers();
    }

    public T fetchOne(String identifier) {
        return (T)this.api.fetchVoucher(identifier);
    }

    public R consumeVoucher(String identifier) {
        return (R)this.api.useVoucher(identifier);
    }

    public class Async {
    }

    public class Rx {
    }

    public class ExtRxJava
    extends Rx {
        public Observable<T> fetchOne(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<T>(){

                @Override
                public T method() {
                    return BaseModule.this.fetchOne(identifier);
                }
            });
        }

        public Observable<List<T>> fetchAll() {
            return RxUtils.defer(new RxUtils.DefFunc<List<T>>(){

                @Override
                public List<T> method() {
                    return BaseModule.this.fetchAll();
                }
            });
        }

        public Observable<R> consumeVoucher(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<R>(){

                @Override
                public R method() {
                    return BaseModule.this.consumeVoucher(identifier);
                }
            });
        }
    }

    public class ExtAsync
    extends Async {
        public void fetchAll(VoucherifyCallback<List<Voucher>> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).fetchAll(), callback);
        }

        public void fetchOne(String identifier, VoucherifyCallback<Voucher> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).fetchOne(identifier), callback);
        }

        public void consumeVoucher(String identifier, VoucherifyCallback<R> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).consumeVoucher(identifier), callback);
        }
    }
}

