/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.module;

import java.util.concurrent.Executor;
import pl.rspective.voucherify.client.api.VoucherifyApi;
import pl.rspective.voucherify.client.callback.VoucherifyCallback;
import pl.rspective.voucherify.client.module.AbsModule;
import pl.rspective.voucherify.client.utils.RxUtils;
import rx.Observable;

abstract class BaseModule<T, R>
extends AbsModule<ExtAsync, ExtRxJava> {
    public BaseModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    public T fetchVoucher(String identifier) {
        return (T)this.api.fetch(identifier);
    }

    public T consumeVoucher(String identifier, String trackingId) {
        return (T)this.api.use(identifier, trackingId);
    }

    public R usageVoucher(String identifier) {
        return (R)this.api.usage(identifier);
    }

    public class Async {
    }

    public class Rx {
    }

    public class ExtRxJava
    extends Rx {
        public Observable<T> fetchVoucher(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<T>(){

                @Override
                public T method() {
                    return BaseModule.this.fetchVoucher(identifier);
                }
            });
        }

        public Observable<T> consumeVoucher(final String identifier, final String trackingId) {
            return RxUtils.defer(new RxUtils.DefFunc<T>(){

                @Override
                public T method() {
                    return BaseModule.this.consumeVoucher(identifier, trackingId);
                }
            });
        }

        public Observable<R> usageVoucher(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<R>(){

                @Override
                public R method() {
                    return BaseModule.this.usageVoucher(identifier);
                }
            });
        }
    }

    public class ExtAsync
    extends Async {
        public void fetchVoucher(String identifier, VoucherifyCallback<T> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).fetchVoucher(identifier), callback);
        }

        public void consumeVoucher(String identifier, String trackingId, VoucherifyCallback<T> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).consumeVoucher(identifier, trackingId), callback);
        }

        public void usageVoucher(String identifier, VoucherifyCallback<R> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).usageVoucher(identifier), callback);
        }
    }
}

