/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.module;

import java.util.concurrent.Executor;
import pl.rspective.voucherify.client.api.VoucherifyApi;
import pl.rspective.voucherify.client.callback.VoucherifyCallback;
import pl.rspective.voucherify.client.model.VoucherRedemptionContext;
import pl.rspective.voucherify.client.module.AbsModule;
import pl.rspective.voucherify.client.utils.RxUtils;
import rx.Observable;

abstract class BaseModule<T, R, RR>
extends AbsModule<ExtAsync, ExtRxJava> {
    public BaseModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    public T fetchVoucher(String identifier) {
        return (T)this.api.fetch(identifier);
    }

    public RR redeem(String identifier, String trackingId) {
        return (RR)this.api.redeem(identifier, trackingId);
    }

    public RR redeem(String identifier, VoucherRedemptionContext redemptionContext) {
        return (RR)this.api.redeem(identifier, redemptionContext);
    }

    public R redemption(String identifier) {
        return (R)this.api.redemption(identifier);
    }

    public class Async {
    }

    public class Rx {
    }

    public class ExtRxJava
    extends Rx {
        public Observable<T> fetchVoucher(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<T>(){

                @Override
                public T method() {
                    return BaseModule.this.fetchVoucher(identifier);
                }
            });
        }

        public Observable<RR> redeem(final String identifier, final String trackingId) {
            return RxUtils.defer(new RxUtils.DefFunc<RR>(){

                @Override
                public RR method() {
                    return BaseModule.this.redeem(identifier, trackingId);
                }
            });
        }

        public Observable<RR> redeem(final String identifier, final VoucherRedemptionContext redemptionContext) {
            return RxUtils.defer(new RxUtils.DefFunc<RR>(){

                @Override
                public RR method() {
                    return BaseModule.this.redeem(identifier, redemptionContext);
                }
            });
        }

        public Observable<R> redemption(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<R>(){

                @Override
                public R method() {
                    return BaseModule.this.redemption(identifier);
                }
            });
        }
    }

    public class ExtAsync
    extends Async {
        public void fetchVoucher(String identifier, VoucherifyCallback<T> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).fetchVoucher(identifier), callback);
        }

        public void redeem(String identifier, String trackingId, VoucherifyCallback<T> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).redeem(identifier, trackingId), callback);
        }

        public void redeem(String identifier, VoucherRedemptionContext redemptionContext, VoucherifyCallback<T> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).redeem(identifier, redemptionContext), callback);
        }

        public void redemption(String identifier, VoucherifyCallback<R> callback) {
            RxUtils.subscribe(BaseModule.this.executor, ((ExtRxJava)BaseModule.this.rx()).redemption(identifier), callback);
        }
    }
}

