/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.model;

import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pl.rspective.voucherify.client.model.RedemptionResult;

public class RedemptionsFilter
extends AbstractMap<String, Object> {
    private final Integer limit;
    private final Date startDate;
    private final Date endDate;
    private final List<RedemptionResult> results;
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");

    private RedemptionsFilter(Integer limit, Date startDate, Date endDate, List<RedemptionResult> results) {
        this.limit = limit;
        this.startDate = startDate;
        this.endDate = endDate;
        this.results = results;
    }

    public static RedemptionsFilter filter() {
        return new RedemptionsFilter(null, null, null, null);
    }

    public RedemptionsFilter withLimit(Integer limit) {
        return new RedemptionsFilter(limit, this.startDate, this.endDate, this.results);
    }

    public RedemptionsFilter withStartDate(Date startDate) {
        return new RedemptionsFilter(this.limit, startDate, this.endDate, this.results);
    }

    public RedemptionsFilter withEndDate(Date endDate) {
        return new RedemptionsFilter(this.limit, this.startDate, endDate, this.results);
    }

    public RedemptionsFilter withResult(RedemptionResult ... results) {
        return new RedemptionsFilter(this.limit, this.startDate, this.endDate, Arrays.asList(results));
    }

    private String formatDate(Date date) {
        if (date != null) {
            return DATE_FORMATTER.format(date);
        }
        return null;
    }

    private static Map.Entry<String, Object> newEntry(String key, Object value) {
        return new AbstractMap.SimpleEntry<String, Object>(key, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        entries.add(RedemptionsFilter.newEntry("limit", this.limit));
        entries.add(RedemptionsFilter.newEntry("start_date", this.formatDate(this.startDate)));
        entries.add(RedemptionsFilter.newEntry("end_date", this.formatDate(this.endDate)));
        if (this.results != null) {
            for (RedemptionResult result : this.results) {
                entries.add(RedemptionsFilter.newEntry("result", (Object)result));
            }
        }
        return Collections.unmodifiableSet(entries);
    }
}

