/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.module;

import java.util.List;
import java.util.concurrent.Executor;
import pl.rspective.voucherify.client.api.VoucherifyApi;
import pl.rspective.voucherify.client.callback.VoucherifyCallback;
import pl.rspective.voucherify.client.model.RedemptionDetails;
import pl.rspective.voucherify.client.model.RedemptionsFilter;
import pl.rspective.voucherify.client.model.Voucher;
import pl.rspective.voucherify.client.model.VoucherRedemption;
import pl.rspective.voucherify.client.model.VoucherRedemptionContext;
import pl.rspective.voucherify.client.model.VoucherRedemptionResult;
import pl.rspective.voucherify.client.model.VouchersFilter;
import pl.rspective.voucherify.client.module.AbsModule;
import pl.rspective.voucherify.client.utils.RxUtils;
import rx.Observable;

public final class VoucherModule
extends AbsModule<ExtAsync, ExtRxJava> {
    public VoucherModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    public List<Voucher> listVouchers(VouchersFilter filter) {
        return this.api.listVouchers(filter);
    }

    public Voucher fetchVoucher(String identifier) {
        return this.api.fetch(identifier);
    }

    public VoucherRedemptionResult redeem(String identifier, String trackingId) {
        return this.api.redeem(identifier, trackingId);
    }

    public VoucherRedemptionResult redeem(String identifier, VoucherRedemptionContext redemptionContext) {
        return this.api.redeem(identifier, redemptionContext);
    }

    public VoucherRedemption redemption(String identifier) {
        return this.api.redemption(identifier);
    }

    public List<RedemptionDetails> listRedemptions(RedemptionsFilter filter) {
        return this.api.listRedemptions(filter);
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    @Override
    public ExtAsync async() {
        return (ExtAsync)this.extAsync;
    }

    @Override
    public ExtRxJava rx() {
        return (ExtRxJava)this.extRxJava;
    }

    public class ExtRxJava
    extends AbsModule.Rx {
        public Observable<List<Voucher>> listVouchers(final VouchersFilter filter) {
            return RxUtils.defer(new RxUtils.DefFunc<List<Voucher>>(){

                @Override
                public List<Voucher> method() {
                    return VoucherModule.this.listVouchers(filter);
                }
            });
        }

        public Observable<Voucher> fetchVoucher(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<Voucher>(){

                @Override
                public Voucher method() {
                    return VoucherModule.this.fetchVoucher(identifier);
                }
            });
        }

        public Observable<VoucherRedemptionResult> redeem(final String identifier, final String trackingId) {
            return RxUtils.defer(new RxUtils.DefFunc<VoucherRedemptionResult>(){

                @Override
                public VoucherRedemptionResult method() {
                    return VoucherModule.this.redeem(identifier, trackingId);
                }
            });
        }

        public Observable<VoucherRedemptionResult> redeem(final String identifier, final VoucherRedemptionContext redemptionContext) {
            return RxUtils.defer(new RxUtils.DefFunc<VoucherRedemptionResult>(){

                @Override
                public VoucherRedemptionResult method() {
                    return VoucherModule.this.redeem(identifier, redemptionContext);
                }
            });
        }

        public Observable<VoucherRedemption> redemption(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<VoucherRedemption>(){

                @Override
                public VoucherRedemption method() {
                    return VoucherModule.this.redemption(identifier);
                }
            });
        }

        public Observable<List<RedemptionDetails>> listRedemptions(final RedemptionsFilter filter) {
            return RxUtils.defer(new RxUtils.DefFunc<List<RedemptionDetails>>(){

                @Override
                public List<RedemptionDetails> method() {
                    return VoucherModule.this.listRedemptions(filter);
                }
            });
        }
    }

    public class ExtAsync
    extends AbsModule.Async {
        public void listVouchers(VouchersFilter filter, VoucherifyCallback<List<Voucher>> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().listVouchers(filter), callback);
        }

        public void fetchVoucher(String identifier, VoucherifyCallback<Voucher> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().fetchVoucher(identifier), callback);
        }

        public void redeem(String identifier, String trackingId, VoucherifyCallback<VoucherRedemptionResult> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().redeem(identifier, trackingId), callback);
        }

        public void redeem(String identifier, VoucherRedemptionContext redemptionContext, VoucherifyCallback<VoucherRedemptionResult> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().redeem(identifier, redemptionContext), callback);
        }

        public void redemption(String identifier, VoucherifyCallback<VoucherRedemption> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().redemption(identifier), callback);
        }

        public void listRedemptions(RedemptionsFilter filter, VoucherifyCallback<List<RedemptionDetails>> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().listRedemptions(filter), callback);
        }
    }
}

