/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.model;

import com.google.gson.annotations.SerializedName;
import pl.rspective.voucherify.client.model.DiscountType;

public class Discount {
    private DiscountType type;
    @SerializedName(value="amount_off")
    private Integer amountOff;
    @SerializedName(value="percent_off")
    private Double percentOff;
    @SerializedName(value="unit_off")
    private Double unitOff;
    @SerializedName(value="unit_type")
    private String unitType;

    public static Discount from(DiscountType type, int value) {
        Discount discount = new Discount();
        discount.type = type;
        switch (type) {
            case AMOUNT: {
                discount.amountOff = value;
                break;
            }
            case PERCENT: {
                discount.percentOff = (double)value / 100.0;
                break;
            }
            case UNIT: {
                discount.unitOff = (double)value / 100.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported discount type: " + (Object)((Object)type));
            }
        }
        return discount;
    }

    public static Discount amountOff(int amountOff) {
        Discount discount = new Discount();
        discount.type = DiscountType.AMOUNT;
        discount.amountOff = amountOff;
        return discount;
    }

    public static Discount percentOff(double percentOff) {
        Discount discount = new Discount();
        discount.type = DiscountType.PERCENT;
        discount.percentOff = percentOff;
        return discount;
    }

    public static Discount unitOff(double unitOff) {
        Discount discount = new Discount();
        discount.type = DiscountType.UNIT;
        discount.unitOff = unitOff;
        return discount;
    }

    public DiscountType getType() {
        return this.type;
    }

    public Integer getAmountOff() {
        return this.amountOff;
    }

    public Double getPercentOff() {
        return this.percentOff;
    }

    public Double getUnitOff() {
        return this.unitOff;
    }

    public String getUnitType() {
        return this.unitType;
    }
}

