/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.model;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;
import pl.rspective.voucherify.client.model.Discount;
import pl.rspective.voucherify.client.model.VoucherPublish;
import pl.rspective.voucherify.client.model.VoucherRedemption;

public class Voucher {
    private String id;
    private String code;
    private String campaign;
    private String category;
    private Discount discount;
    @SerializedName(value="start_date")
    private Date startDate;
    @SerializedName(value="expiration_date")
    private Date expirationDate;
    private boolean active;
    private VoucherPublish publish;
    private VoucherRedemption redemption;
    @SerializedName(value="additional_info")
    private String additionalInfo;
    private Map<String, Object> metadata;

    private Voucher() {
    }

    private Voucher(String id, String code, String campaign, String category, Discount discount, Date startDate, Date expirationDate, VoucherRedemption redemption, Boolean active, String additionalInfo, Map<String, Object> metadata) {
        this.id = id;
        this.code = code;
        this.campaign = campaign;
        this.category = category;
        this.discount = discount;
        this.startDate = startDate;
        this.expirationDate = expirationDate;
        this.publish = new VoucherPublish();
        this.redemption = redemption;
        this.active = active;
        this.additionalInfo = additionalInfo;
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getCampaign() {
        return this.campaign;
    }

    public String getCategory() {
        return this.category;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isActive() {
        return this.active;
    }

    public VoucherPublish getPublish() {
        return this.publish;
    }

    public VoucherRedemption getRedemption() {
        return this.redemption;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public static class Builder {
        private String id;
        private String code;
        private String campaign;
        private String category;
        private Discount discount;
        private Date startDate;
        private Date expirationDate;
        private VoucherRedemption redemption;
        private boolean active = true;
        private String additionalInfo;
        private Map<String, Object> metadata;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public Builder setCampaign(String campaign) {
            this.campaign = campaign;
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setDiscount(Discount discount) {
            this.discount = discount;
            return this;
        }

        public Builder setAmountOff(int amountOff) {
            this.discount = Discount.amountOff(amountOff);
            return this;
        }

        public Builder setPercentOff(double percentOff) {
            this.discount = Discount.percentOff(percentOff);
            return this;
        }

        public Builder setUnitOff(double unitOff) {
            this.discount = Discount.unitOff(unitOff);
            return this;
        }

        public Builder setStartDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder setExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public Builder setRedemption(VoucherRedemption redemption) {
            this.redemption = redemption;
            return this;
        }

        public Builder setRedemptionLimit(int limit) {
            this.redemption = VoucherRedemption.quantity(limit);
            return this;
        }

        public Builder setActive(boolean active) {
            this.active = active;
            return this;
        }

        public Builder setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder enabled() {
            this.active = true;
            return this;
        }

        public Builder disabled() {
            this.active = false;
            return this;
        }

        public Voucher build() {
            return new Voucher(this.id, this.code, this.campaign, this.category, this.discount, this.startDate, this.expirationDate, this.redemption, this.active, this.additionalInfo, this.metadata);
        }
    }
}

