/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.api;

import com.squareup.okhttp.Response;
import java.util.List;
import pl.rspective.voucherify.client.model.Customer;
import pl.rspective.voucherify.client.model.PublishParams;
import pl.rspective.voucherify.client.model.RedemptionDetails;
import pl.rspective.voucherify.client.model.RedemptionsFilter;
import pl.rspective.voucherify.client.model.Voucher;
import pl.rspective.voucherify.client.model.VoucherRedemption;
import pl.rspective.voucherify.client.model.VoucherRedemptionContext;
import pl.rspective.voucherify.client.model.VoucherRedemptionResult;
import pl.rspective.voucherify.client.model.VoucherUpdate;
import pl.rspective.voucherify.client.model.VouchersFilter;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;
import retrofit.http.Query;
import retrofit.http.QueryMap;

public interface VoucherifyApi {
    @GET(value="/vouchers/")
    public List<Voucher> listVouchers(@QueryMap VouchersFilter var1);

    @GET(value="/vouchers/{code}")
    public Voucher fetch(@Path(value="code") String var1);

    @POST(value="/vouchers/")
    public Voucher createVoucher(@Body Voucher var1);

    @POST(value="/vouchers/{code}")
    public Voucher createVoucherWithCode(@Path(value="code") String var1, @Body Voucher var2);

    @PUT(value="/vouchers/{code}")
    public Voucher updateVoucher(@Path(value="code") String var1, @Body VoucherUpdate var2);

    @POST(value="/vouchers/{code}/disable")
    public Response disableVoucher(@Path(value="code") String var1);

    @POST(value="/vouchers/{code}/enable")
    public Response enableVoucher(@Path(value="code") String var1);

    @POST(value="/vouchers/{code}/redemption")
    public VoucherRedemptionResult redeem(@Path(value="code") String var1, @Query(value="tracking_id") String var2);

    @POST(value="/vouchers/{code}/redemption")
    public VoucherRedemptionResult redeem(@Path(value="code") String var1, @Body VoucherRedemptionContext var2);

    @GET(value="/vouchers/{code}/redemption")
    public VoucherRedemption redemption(@Path(value="code") String var1);

    @POST(value="/vouchers/publish")
    public Voucher publishVoucher(@Body PublishParams var1);

    @GET(value="/redemptions")
    public List<RedemptionDetails> listRedemptions(@QueryMap RedemptionsFilter var1);

    @POST(value="/redemptions/{id}/rollback")
    public VoucherRedemptionResult rollbackRedemption(@Path(value="id") String var1, @Query(value="tracking_id") String var2, @Query(value="reason") String var3);

    @POST(value="/customers")
    public Customer createCustomer(@Body Customer var1);

    @GET(value="/customers/{id}")
    public Customer getCustomer(@Path(value="id") String var1);

    @PUT(value="/customers/{id}")
    public Customer updateCustomer(@Path(value="id") String var1, @Body Customer var2);

    @DELETE(value="/customers/{id}")
    public Response deleteCustomer(@Path(value="id") String var1);
}

