/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.model;

public class CodeConfig {
    public static final char PATTERN_PLACEHOLDER = '#';
    private final Integer length;
    private final String charset;
    private final String prefix;
    private final String postfix;
    private final String pattern;

    public CodeConfig(Integer length, String charset, String prefix, String postfix, String pattern) {
        this.length = length;
        this.charset = charset;
        this.prefix = prefix;
        this.postfix = postfix;
        this.pattern = pattern;
    }

    public static CodeConfig length(int length) {
        return new CodeConfig(length, null, null, null, null);
    }

    public static CodeConfig pattern(String pattern) {
        return new CodeConfig(null, null, null, null, pattern);
    }

    public Integer getLength() {
        return this.length;
    }

    public String getCharset() {
        return this.charset;
    }

    public CodeConfig withCharset(String charset) {
        return new CodeConfig(this.length, charset, this.prefix, this.postfix, this.pattern);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public CodeConfig withPrefix(String prefix) {
        return new CodeConfig(this.length, this.charset, prefix, this.postfix, this.pattern);
    }

    public String getPostfix() {
        return this.postfix;
    }

    public CodeConfig withPostfix(String postfix) {
        return new CodeConfig(this.length, this.charset, this.prefix, postfix, this.pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public static class Charset {
        public static final String ALPHABETIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        public static final String ALPHANUMERIC = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        public static final String NUMBERS = "0123456789";
    }
}

