/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.module;

import java.util.concurrent.Executor;
import pl.rspective.voucherify.client.api.VoucherifyApi;
import pl.rspective.voucherify.client.callback.VoucherifyCallback;
import pl.rspective.voucherify.client.model.Customer;
import pl.rspective.voucherify.client.module.AbsModule;
import pl.rspective.voucherify.client.utils.RxUtils;
import rx.Observable;

public final class CustomerModule
extends AbsModule<ExtAsync, ExtRxJava> {
    public CustomerModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    public Customer getCustomer(String customerId) {
        return this.api.getCustomer(customerId);
    }

    public Customer createCustomer(Customer customer) {
        return this.api.createCustomer(customer);
    }

    public Customer updateCustomer(Customer customer) {
        return this.api.updateCustomer(customer.getId(), customer);
    }

    public void deleteCustomer(String customerId) {
        this.api.deleteCustomer(customerId);
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    @Override
    public ExtAsync async() {
        return (ExtAsync)this.extAsync;
    }

    @Override
    public ExtRxJava rx() {
        return (ExtRxJava)this.extRxJava;
    }

    public class ExtRxJava
    extends AbsModule.Rx {
        public Observable<Customer> getCustomer(final String customerId) {
            return RxUtils.defer(new RxUtils.DefFunc<Customer>(){

                @Override
                public Customer method() {
                    return CustomerModule.this.getCustomer(customerId);
                }
            });
        }

        public Observable<Customer> createCustomer(final Customer customer) {
            return RxUtils.defer(new RxUtils.DefFunc<Customer>(){

                @Override
                public Customer method() {
                    return CustomerModule.this.createCustomer(customer);
                }
            });
        }

        public Observable<Customer> updateCustomer(final Customer customer) {
            return RxUtils.defer(new RxUtils.DefFunc<Customer>(){

                @Override
                public Customer method() {
                    return CustomerModule.this.updateCustomer(customer);
                }
            });
        }

        public Observable<Void> deleteCustomer(final String customerId) {
            return RxUtils.defer(new RxUtils.DefFunc<Void>(){

                @Override
                public Void method() {
                    CustomerModule.this.deleteCustomer(customerId);
                    return null;
                }
            });
        }
    }

    public class ExtAsync
    extends AbsModule.Async {
        public void getCustomer(String customerId, VoucherifyCallback<Customer> callback) {
            RxUtils.subscribe(CustomerModule.this.executor, CustomerModule.this.rx().getCustomer(customerId), callback);
        }

        public void createCustomer(Customer customer, VoucherifyCallback<Customer> callback) {
            RxUtils.subscribe(CustomerModule.this.executor, CustomerModule.this.rx().createCustomer(customer), callback);
        }

        public void updateCustomer(Customer customer, VoucherifyCallback<Customer> callback) {
            RxUtils.subscribe(CustomerModule.this.executor, CustomerModule.this.rx().updateCustomer(customer), callback);
        }

        public void deleteCustomer(String customerId, VoucherifyCallback<Void> callback) {
            RxUtils.subscribe(CustomerModule.this.executor, CustomerModule.this.rx().deleteCustomer(customerId), callback);
        }
    }
}

