/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Date;
import java.util.concurrent.Executor;
import pl.rspective.voucherify.client.api.VoucherifyApi;
import pl.rspective.voucherify.client.json.DateDeserializer;
import pl.rspective.voucherify.client.json.DateSerializer;
import pl.rspective.voucherify.client.module.CustomerModule;
import pl.rspective.voucherify.client.module.VoucherModule;
import pl.rspective.voucherify.client.utils.Platform;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class VoucherifyClient {
    private final String httpScheme;
    private Gson gson;
    private VoucherModule voucherModule;
    private CustomerModule customerModule;
    private VoucherifyApi voucherifyApi;
    private Executor executor;

    private VoucherifyClient(Builder builder) {
        if (builder.appToken == null) {
            throw new IllegalArgumentException("App token must be defined.");
        }
        if (builder.appId == null) {
            throw new IllegalArgumentException("App ID must be defined.");
        }
        this.httpScheme = this.createHttpScheme(builder);
        this.executor = this.createCallbackExecutor();
        this.gson = this.createGson();
        this.voucherifyApi = this.createRetrofitService(builder);
        this.voucherModule = new VoucherModule(this.voucherifyApi, this.executor);
        this.customerModule = new CustomerModule(this.voucherifyApi, this.executor);
    }

    public VoucherModule vouchers() {
        return this.voucherModule;
    }

    public CustomerModule customers() {
        return this.customerModule;
    }

    private Executor createCallbackExecutor() {
        return Platform.get().callbackExecutor();
    }

    private Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateSerializer("yyyy-MM-dd'T'HH:mm:ssXXX")).registerTypeAdapter(Date.class, (Object)new DateDeserializer("yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX")).create();
    }

    private String createHttpScheme(Builder builder) {
        if (builder.secure) {
            return "https";
        }
        return "http";
    }

    private VoucherifyApi createRetrofitService(Builder builder) {
        RestAdapter.Builder restBuilder = new RestAdapter.Builder().setConverter((Converter)new GsonConverter(this.gson)).setRequestInterceptor(this.createInterceptor(builder.appId, builder.appToken));
        this.setEndPoint(builder, restBuilder);
        this.setClientProvider(builder, restBuilder);
        this.setLogLevel(builder, restBuilder);
        return (VoucherifyApi)restBuilder.build().create(VoucherifyApi.class);
    }

    private RequestInterceptor createInterceptor(final String appId, final String appToken) {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("X-Voucherify-Channel", "Java-SDK");
                request.addHeader("X-App-Id", appId);
                request.addHeader("X-App-Token", appToken);
            }
        };
    }

    private void setLogLevel(Builder builder, RestAdapter.Builder restBuilder) {
        if (builder.logLevel != null) {
            restBuilder.setLogLevel(builder.logLevel);
        }
    }

    private void setClientProvider(Builder builder, RestAdapter.Builder restBuilder) {
        if (builder.clientProvider != null) {
            restBuilder.setClient(builder.clientProvider);
        }
    }

    private void setEndPoint(Builder builder, RestAdapter.Builder restBuilder) {
        String endpoint = builder.endpoint == null ? "api.voucherify.io/v1" : builder.endpoint;
        restBuilder.setEndpoint(String.format("%s://%s", this.httpScheme, endpoint));
    }

    public static class Builder {
        String appToken;
        String appId;
        String endpoint;
        boolean secure = true;
        RestAdapter.LogLevel logLevel;
        Client.Provider clientProvider;

        public Builder setAppToken(String appToken) {
            if (appToken == null) {
                throw new IllegalArgumentException("Cannot call setAppToken() with null.");
            }
            this.appToken = appToken;
            return this;
        }

        public Builder setAppId(String appId) {
            if (appId == null) {
                throw new IllegalArgumentException("Cannot call setAppId() with null.");
            }
            this.appId = appId;
            return this;
        }

        public Builder setClient(final Client client) {
            if (client == null) {
                throw new IllegalArgumentException("Cannot call setClient() with null.");
            }
            return this.setClientProvider(new Client.Provider(){

                public Client get() {
                    return client;
                }
            });
        }

        public Builder setEndpoint(String remoteUrl) {
            if (remoteUrl == null) {
                throw new IllegalArgumentException("Cannot call setEndpoint() with null.");
            }
            this.endpoint = remoteUrl;
            return this;
        }

        public Builder setClientProvider(Client.Provider clientProvider) {
            if (clientProvider == null) {
                throw new IllegalArgumentException("Cannot call setClientProvider() with null.");
            }
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder setLogLevel(RestAdapter.LogLevel logLevel) {
            if (logLevel == null) {
                throw new IllegalArgumentException("Cannot call setLogLevel() with null.");
            }
            this.logLevel = logLevel;
            return this;
        }

        public Builder withSSL() {
            this.secure = true;
            return this;
        }

        public Builder withoutSSL() {
            this.secure = false;
            return this;
        }

        public VoucherifyClient build() {
            return new VoucherifyClient(this);
        }
    }
}

