/*
 * Decompiled with CFR 0.152.
 */
package pl.rspective.voucherify.client.module;

import java.util.List;
import java.util.concurrent.Executor;
import pl.rspective.voucherify.client.api.VoucherifyApi;
import pl.rspective.voucherify.client.callback.VoucherifyCallback;
import pl.rspective.voucherify.client.model.PublishParams;
import pl.rspective.voucherify.client.model.RedemptionsFilter;
import pl.rspective.voucherify.client.model.RedemptionsList;
import pl.rspective.voucherify.client.model.Voucher;
import pl.rspective.voucherify.client.model.VoucherRedemption;
import pl.rspective.voucherify.client.model.VoucherRedemptionContext;
import pl.rspective.voucherify.client.model.VoucherRedemptionResult;
import pl.rspective.voucherify.client.model.VoucherUpdate;
import pl.rspective.voucherify.client.model.VoucherValidationContext;
import pl.rspective.voucherify.client.model.VoucherValidationResult;
import pl.rspective.voucherify.client.model.VouchersFilter;
import pl.rspective.voucherify.client.module.AbsModule;
import pl.rspective.voucherify.client.utils.RxUtils;
import rx.Observable;

public final class VoucherModule
extends AbsModule<ExtAsync, ExtRxJava> {
    public VoucherModule(VoucherifyApi api, Executor executor) {
        super(api, executor);
    }

    public List<Voucher> listVouchers(VouchersFilter filter) {
        return this.api.listVouchers(filter);
    }

    public Voucher fetchVoucher(String identifier) {
        return this.api.fetch(identifier);
    }

    public Voucher createVoucher(Voucher voucher) {
        if (voucher.getCode() != null) {
            return this.api.createVoucherWithCode(voucher.getCode(), voucher);
        }
        return this.api.createVoucher(voucher);
    }

    public Voucher updateVoucher(String code, VoucherUpdate voucherUpdate) {
        return this.api.updateVoucher(code, voucherUpdate);
    }

    public Voucher publishVoucher(PublishParams publishParams) {
        return this.api.publishVoucher(publishParams);
    }

    public void disableVoucher(String code) {
        this.api.disableVoucher(code);
    }

    public void enableVoucher(String code) {
        this.api.enableVoucher(code);
    }

    public VoucherRedemptionResult redeem(String identifier, String trackingId) {
        return this.api.redeem(identifier, trackingId);
    }

    public VoucherRedemptionResult redeem(String identifier, VoucherRedemptionContext redemptionContext) {
        return this.api.redeem(identifier, redemptionContext);
    }

    public VoucherRedemption redemption(String identifier) {
        return this.api.redemption(identifier);
    }

    public RedemptionsList listRedemptions(RedemptionsFilter filter) {
        return this.api.listRedemptions(filter);
    }

    public VoucherRedemptionResult rollbackRedemption(String redemptionId, String trackingId, String reason) {
        return this.api.rollbackRedemption(redemptionId, trackingId, reason);
    }

    public VoucherValidationResult validate(String code, VoucherValidationContext validityContext) {
        return this.api.validate(code, validityContext);
    }

    @Override
    ExtAsync createAsyncExtension() {
        return new ExtAsync();
    }

    @Override
    ExtRxJava createRxJavaExtension() {
        return new ExtRxJava();
    }

    @Override
    public ExtAsync async() {
        return (ExtAsync)this.extAsync;
    }

    @Override
    public ExtRxJava rx() {
        return (ExtRxJava)this.extRxJava;
    }

    public class ExtRxJava
    extends AbsModule.Rx {
        public Observable<List<Voucher>> listVouchers(final VouchersFilter filter) {
            return RxUtils.defer(new RxUtils.DefFunc<List<Voucher>>(){

                @Override
                public List<Voucher> method() {
                    return VoucherModule.this.listVouchers(filter);
                }
            });
        }

        public Observable<Voucher> fetchVoucher(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<Voucher>(){

                @Override
                public Voucher method() {
                    return VoucherModule.this.fetchVoucher(identifier);
                }
            });
        }

        public Observable<Voucher> createVoucher(final Voucher voucher) {
            return RxUtils.defer(new RxUtils.DefFunc<Voucher>(){

                @Override
                public Voucher method() {
                    return VoucherModule.this.createVoucher(voucher);
                }
            });
        }

        public Observable<Voucher> updateVoucher(final String code, final VoucherUpdate voucherUpdate) {
            return RxUtils.defer(new RxUtils.DefFunc<Voucher>(){

                @Override
                public Voucher method() {
                    return VoucherModule.this.updateVoucher(code, voucherUpdate);
                }
            });
        }

        public Observable<Void> disableVoucher(final String code) {
            return RxUtils.defer(new RxUtils.DefFunc<Void>(){

                @Override
                public Void method() {
                    VoucherModule.this.disableVoucher(code);
                    return null;
                }
            });
        }

        public Observable<Void> enableVoucher(final String code) {
            return RxUtils.defer(new RxUtils.DefFunc<Void>(){

                @Override
                public Void method() {
                    VoucherModule.this.enableVoucher(code);
                    return null;
                }
            });
        }

        public Observable<VoucherRedemptionResult> redeem(final String identifier, final String trackingId) {
            return RxUtils.defer(new RxUtils.DefFunc<VoucherRedemptionResult>(){

                @Override
                public VoucherRedemptionResult method() {
                    return VoucherModule.this.redeem(identifier, trackingId);
                }
            });
        }

        public Observable<VoucherRedemptionResult> redeem(final String identifier, final VoucherRedemptionContext redemptionContext) {
            return RxUtils.defer(new RxUtils.DefFunc<VoucherRedemptionResult>(){

                @Override
                public VoucherRedemptionResult method() {
                    return VoucherModule.this.redeem(identifier, redemptionContext);
                }
            });
        }

        public Observable<Voucher> publishVoucher(final PublishParams publishParams) {
            return RxUtils.defer(new RxUtils.DefFunc<Voucher>(){

                @Override
                public Voucher method() {
                    return VoucherModule.this.publishVoucher(publishParams);
                }
            });
        }

        public Observable<VoucherRedemption> redemption(final String identifier) {
            return RxUtils.defer(new RxUtils.DefFunc<VoucherRedemption>(){

                @Override
                public VoucherRedemption method() {
                    return VoucherModule.this.redemption(identifier);
                }
            });
        }

        public Observable<RedemptionsList> listRedemptions(final RedemptionsFilter filter) {
            return RxUtils.defer(new RxUtils.DefFunc<RedemptionsList>(){

                @Override
                public RedemptionsList method() {
                    return VoucherModule.this.listRedemptions(filter);
                }
            });
        }

        public Observable<VoucherRedemptionResult> rollbackRedemption(final String redemptionId, final String trackingId, final String reason) {
            return RxUtils.defer(new RxUtils.DefFunc<VoucherRedemptionResult>(){

                @Override
                public VoucherRedemptionResult method() {
                    return VoucherModule.this.api.rollbackRedemption(redemptionId, trackingId, reason);
                }
            });
        }

        public Observable<VoucherValidationResult> validate(final String code, final VoucherValidationContext validityContext) {
            return RxUtils.defer(new RxUtils.DefFunc<VoucherValidationResult>(){

                @Override
                public VoucherValidationResult method() {
                    return VoucherModule.this.api.validate(code, validityContext);
                }
            });
        }
    }

    public class ExtAsync
    extends AbsModule.Async {
        public void listVouchers(VouchersFilter filter, VoucherifyCallback<List<Voucher>> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().listVouchers(filter), callback);
        }

        public void fetchVoucher(String identifier, VoucherifyCallback<Voucher> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().fetchVoucher(identifier), callback);
        }

        public void createVoucher(Voucher voucher, VoucherifyCallback<Voucher> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().createVoucher(voucher), callback);
        }

        public void updateVoucher(String code, VoucherUpdate voucherUpdate, VoucherifyCallback<Voucher> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().updateVoucher(code, voucherUpdate), callback);
        }

        public void disableVoucher(String code, VoucherifyCallback<Void> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().disableVoucher(code), callback);
        }

        public void enableVoucher(String code, VoucherifyCallback<Void> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().disableVoucher(code), callback);
        }

        public void publishVoucher(PublishParams publishParams, VoucherifyCallback<Voucher> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().publishVoucher(publishParams), callback);
        }

        public void redeem(String identifier, String trackingId, VoucherifyCallback<VoucherRedemptionResult> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().redeem(identifier, trackingId), callback);
        }

        public void redeem(String identifier, VoucherRedemptionContext redemptionContext, VoucherifyCallback<VoucherRedemptionResult> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().redeem(identifier, redemptionContext), callback);
        }

        public void redemption(String identifier, VoucherifyCallback<VoucherRedemption> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().redemption(identifier), callback);
        }

        public void listRedemptions(RedemptionsFilter filter, VoucherifyCallback<RedemptionsList> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().listRedemptions(filter), callback);
        }

        public void rollbackRedemption(String redemptionId, String trackingId, String reason, VoucherifyCallback<VoucherRedemptionResult> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().rollbackRedemption(redemptionId, trackingId, reason), callback);
        }

        public void validate(String code, VoucherValidationContext validityContext, VoucherifyCallback<VoucherValidationResult> callback) {
            RxUtils.subscribe(VoucherModule.this.executor, VoucherModule.this.rx().validate(code, validityContext), callback);
        }
    }
}

